// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCiliumIdentities implements CiliumIdentityInterface
type FakeCiliumIdentities struct {
	Fake *FakeCiliumV2
}

var ciliumidentitiesResource = v2.SchemeGroupVersion.WithResource("ciliumidentities")

var ciliumidentitiesKind = v2.SchemeGroupVersion.WithKind("CiliumIdentity")

// Get takes name of the ciliumIdentity, and returns the corresponding ciliumIdentity object, and an error if there is any.
func (c *FakeCiliumIdentities) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.CiliumIdentity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(ciliumidentitiesResource, name), &v2.CiliumIdentity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.CiliumIdentity), err
}

// List takes label and field selectors, and returns the list of CiliumIdentities that match those selectors.
func (c *FakeCiliumIdentities) List(ctx context.Context, opts v1.ListOptions) (result *v2.CiliumIdentityList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(ciliumidentitiesResource, ciliumidentitiesKind, opts), &v2.CiliumIdentityList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2.CiliumIdentityList{ListMeta: obj.(*v2.CiliumIdentityList).ListMeta}
	for _, item := range obj.(*v2.CiliumIdentityList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ciliumIdentities.
func (c *FakeCiliumIdentities) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(ciliumidentitiesResource, opts))
}

// Create takes the representation of a ciliumIdentity and creates it.  Returns the server's representation of the ciliumIdentity, and an error, if there is any.
func (c *FakeCiliumIdentities) Create(ctx context.Context, ciliumIdentity *v2.CiliumIdentity, opts v1.CreateOptions) (result *v2.CiliumIdentity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(ciliumidentitiesResource, ciliumIdentity), &v2.CiliumIdentity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.CiliumIdentity), err
}

// Update takes the representation of a ciliumIdentity and updates it. Returns the server's representation of the ciliumIdentity, and an error, if there is any.
func (c *FakeCiliumIdentities) Update(ctx context.Context, ciliumIdentity *v2.CiliumIdentity, opts v1.UpdateOptions) (result *v2.CiliumIdentity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(ciliumidentitiesResource, ciliumIdentity), &v2.CiliumIdentity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.CiliumIdentity), err
}

// Delete takes name of the ciliumIdentity and deletes it. Returns an error if one occurs.
func (c *FakeCiliumIdentities) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(ciliumidentitiesResource, name, opts), &v2.CiliumIdentity{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCiliumIdentities) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(ciliumidentitiesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v2.CiliumIdentityList{})
	return err
}

// Patch applies the patch and returns the patched ciliumIdentity.
func (c *FakeCiliumIdentities) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumIdentity, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(ciliumidentitiesResource, name, pt, data, subresources...), &v2.CiliumIdentity{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.CiliumIdentity), err
}
