// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.24.0
// source: observer/observer.proto

package observer

import (
	flow "github.com/cilium/cilium/api/v1/flow"
	relay "github.com/cilium/cilium/api/v1/relay"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Symbols defined in public import of flow/flow.proto.

type FlowType = flow.FlowType

const FlowType_UNKNOWN_TYPE = flow.FlowType_UNKNOWN_TYPE
const FlowType_L3_L4 = flow.FlowType_L3_L4
const FlowType_L7 = flow.FlowType_L7
const FlowType_SOCK = flow.FlowType_SOCK

var FlowType_name = flow.FlowType_name
var FlowType_value = flow.FlowType_value

type AuthType = flow.AuthType

const AuthType_DISABLED = flow.AuthType_DISABLED
const AuthType_SPIRE = flow.AuthType_SPIRE
const AuthType_TEST_ALWAYS_FAIL = flow.AuthType_TEST_ALWAYS_FAIL

var AuthType_name = flow.AuthType_name
var AuthType_value = flow.AuthType_value

type TraceObservationPoint = flow.TraceObservationPoint

const TraceObservationPoint_UNKNOWN_POINT = flow.TraceObservationPoint_UNKNOWN_POINT
const TraceObservationPoint_TO_PROXY = flow.TraceObservationPoint_TO_PROXY
const TraceObservationPoint_TO_HOST = flow.TraceObservationPoint_TO_HOST
const TraceObservationPoint_TO_STACK = flow.TraceObservationPoint_TO_STACK
const TraceObservationPoint_TO_OVERLAY = flow.TraceObservationPoint_TO_OVERLAY
const TraceObservationPoint_TO_ENDPOINT = flow.TraceObservationPoint_TO_ENDPOINT
const TraceObservationPoint_FROM_ENDPOINT = flow.TraceObservationPoint_FROM_ENDPOINT
const TraceObservationPoint_FROM_PROXY = flow.TraceObservationPoint_FROM_PROXY
const TraceObservationPoint_FROM_HOST = flow.TraceObservationPoint_FROM_HOST
const TraceObservationPoint_FROM_STACK = flow.TraceObservationPoint_FROM_STACK
const TraceObservationPoint_FROM_OVERLAY = flow.TraceObservationPoint_FROM_OVERLAY
const TraceObservationPoint_FROM_NETWORK = flow.TraceObservationPoint_FROM_NETWORK
const TraceObservationPoint_TO_NETWORK = flow.TraceObservationPoint_TO_NETWORK

var TraceObservationPoint_name = flow.TraceObservationPoint_name
var TraceObservationPoint_value = flow.TraceObservationPoint_value

type L7FlowType = flow.L7FlowType

const L7FlowType_UNKNOWN_L7_TYPE = flow.L7FlowType_UNKNOWN_L7_TYPE
const L7FlowType_REQUEST = flow.L7FlowType_REQUEST
const L7FlowType_RESPONSE = flow.L7FlowType_RESPONSE
const L7FlowType_SAMPLE = flow.L7FlowType_SAMPLE

var L7FlowType_name = flow.L7FlowType_name
var L7FlowType_value = flow.L7FlowType_value

type IPVersion = flow.IPVersion

const IPVersion_IP_NOT_USED = flow.IPVersion_IP_NOT_USED
const IPVersion_IPv4 = flow.IPVersion_IPv4
const IPVersion_IPv6 = flow.IPVersion_IPv6

var IPVersion_name = flow.IPVersion_name
var IPVersion_value = flow.IPVersion_value

type Verdict = flow.Verdict

const Verdict_VERDICT_UNKNOWN = flow.Verdict_VERDICT_UNKNOWN
const Verdict_FORWARDED = flow.Verdict_FORWARDED
const Verdict_DROPPED = flow.Verdict_DROPPED
const Verdict_ERROR = flow.Verdict_ERROR
const Verdict_AUDIT = flow.Verdict_AUDIT
const Verdict_REDIRECTED = flow.Verdict_REDIRECTED
const Verdict_TRACED = flow.Verdict_TRACED
const Verdict_TRANSLATED = flow.Verdict_TRANSLATED

var Verdict_name = flow.Verdict_name
var Verdict_value = flow.Verdict_value

type DropReason = flow.DropReason

const DropReason_DROP_REASON_UNKNOWN = flow.DropReason_DROP_REASON_UNKNOWN
const DropReason_INVALID_SOURCE_MAC = flow.DropReason_INVALID_SOURCE_MAC
const DropReason_INVALID_DESTINATION_MAC = flow.DropReason_INVALID_DESTINATION_MAC
const DropReason_INVALID_SOURCE_IP = flow.DropReason_INVALID_SOURCE_IP
const DropReason_POLICY_DENIED = flow.DropReason_POLICY_DENIED
const DropReason_INVALID_PACKET_DROPPED = flow.DropReason_INVALID_PACKET_DROPPED
const DropReason_CT_TRUNCATED_OR_INVALID_HEADER = flow.DropReason_CT_TRUNCATED_OR_INVALID_HEADER
const DropReason_CT_MISSING_TCP_ACK_FLAG = flow.DropReason_CT_MISSING_TCP_ACK_FLAG
const DropReason_CT_UNKNOWN_L4_PROTOCOL = flow.DropReason_CT_UNKNOWN_L4_PROTOCOL
const DropReason_CT_CANNOT_CREATE_ENTRY_FROM_PACKET = flow.DropReason_CT_CANNOT_CREATE_ENTRY_FROM_PACKET
const DropReason_UNSUPPORTED_L3_PROTOCOL = flow.DropReason_UNSUPPORTED_L3_PROTOCOL
const DropReason_MISSED_TAIL_CALL = flow.DropReason_MISSED_TAIL_CALL
const DropReason_ERROR_WRITING_TO_PACKET = flow.DropReason_ERROR_WRITING_TO_PACKET
const DropReason_UNKNOWN_L4_PROTOCOL = flow.DropReason_UNKNOWN_L4_PROTOCOL
const DropReason_UNKNOWN_ICMPV4_CODE = flow.DropReason_UNKNOWN_ICMPV4_CODE
const DropReason_UNKNOWN_ICMPV4_TYPE = flow.DropReason_UNKNOWN_ICMPV4_TYPE
const DropReason_UNKNOWN_ICMPV6_CODE = flow.DropReason_UNKNOWN_ICMPV6_CODE
const DropReason_UNKNOWN_ICMPV6_TYPE = flow.DropReason_UNKNOWN_ICMPV6_TYPE
const DropReason_ERROR_RETRIEVING_TUNNEL_KEY = flow.DropReason_ERROR_RETRIEVING_TUNNEL_KEY
const DropReason_ERROR_RETRIEVING_TUNNEL_OPTIONS = flow.DropReason_ERROR_RETRIEVING_TUNNEL_OPTIONS
const DropReason_INVALID_GENEVE_OPTION = flow.DropReason_INVALID_GENEVE_OPTION
const DropReason_UNKNOWN_L3_TARGET_ADDRESS = flow.DropReason_UNKNOWN_L3_TARGET_ADDRESS
const DropReason_STALE_OR_UNROUTABLE_IP = flow.DropReason_STALE_OR_UNROUTABLE_IP
const DropReason_NO_MATCHING_LOCAL_CONTAINER_FOUND = flow.DropReason_NO_MATCHING_LOCAL_CONTAINER_FOUND
const DropReason_ERROR_WHILE_CORRECTING_L3_CHECKSUM = flow.DropReason_ERROR_WHILE_CORRECTING_L3_CHECKSUM
const DropReason_ERROR_WHILE_CORRECTING_L4_CHECKSUM = flow.DropReason_ERROR_WHILE_CORRECTING_L4_CHECKSUM
const DropReason_CT_MAP_INSERTION_FAILED = flow.DropReason_CT_MAP_INSERTION_FAILED
const DropReason_INVALID_IPV6_EXTENSION_HEADER = flow.DropReason_INVALID_IPV6_EXTENSION_HEADER
const DropReason_IP_FRAGMENTATION_NOT_SUPPORTED = flow.DropReason_IP_FRAGMENTATION_NOT_SUPPORTED
const DropReason_SERVICE_BACKEND_NOT_FOUND = flow.DropReason_SERVICE_BACKEND_NOT_FOUND
const DropReason_NO_TUNNEL_OR_ENCAPSULATION_ENDPOINT = flow.DropReason_NO_TUNNEL_OR_ENCAPSULATION_ENDPOINT
const DropReason_FAILED_TO_INSERT_INTO_PROXYMAP = flow.DropReason_FAILED_TO_INSERT_INTO_PROXYMAP
const DropReason_REACHED_EDT_RATE_LIMITING_DROP_HORIZON = flow.DropReason_REACHED_EDT_RATE_LIMITING_DROP_HORIZON
const DropReason_UNKNOWN_CONNECTION_TRACKING_STATE = flow.DropReason_UNKNOWN_CONNECTION_TRACKING_STATE
const DropReason_LOCAL_HOST_IS_UNREACHABLE = flow.DropReason_LOCAL_HOST_IS_UNREACHABLE
const DropReason_NO_CONFIGURATION_AVAILABLE_TO_PERFORM_POLICY_DECISION = flow.DropReason_NO_CONFIGURATION_AVAILABLE_TO_PERFORM_POLICY_DECISION
const DropReason_UNSUPPORTED_L2_PROTOCOL = flow.DropReason_UNSUPPORTED_L2_PROTOCOL
const DropReason_NO_MAPPING_FOR_NAT_MASQUERADE = flow.DropReason_NO_MAPPING_FOR_NAT_MASQUERADE
const DropReason_UNSUPPORTED_PROTOCOL_FOR_NAT_MASQUERADE = flow.DropReason_UNSUPPORTED_PROTOCOL_FOR_NAT_MASQUERADE
const DropReason_FIB_LOOKUP_FAILED = flow.DropReason_FIB_LOOKUP_FAILED
const DropReason_ENCAPSULATION_TRAFFIC_IS_PROHIBITED = flow.DropReason_ENCAPSULATION_TRAFFIC_IS_PROHIBITED
const DropReason_INVALID_IDENTITY = flow.DropReason_INVALID_IDENTITY
const DropReason_UNKNOWN_SENDER = flow.DropReason_UNKNOWN_SENDER
const DropReason_NAT_NOT_NEEDED = flow.DropReason_NAT_NOT_NEEDED
const DropReason_IS_A_CLUSTERIP = flow.DropReason_IS_A_CLUSTERIP
const DropReason_FIRST_LOGICAL_DATAGRAM_FRAGMENT_NOT_FOUND = flow.DropReason_FIRST_LOGICAL_DATAGRAM_FRAGMENT_NOT_FOUND
const DropReason_FORBIDDEN_ICMPV6_MESSAGE = flow.DropReason_FORBIDDEN_ICMPV6_MESSAGE
const DropReason_DENIED_BY_LB_SRC_RANGE_CHECK = flow.DropReason_DENIED_BY_LB_SRC_RANGE_CHECK
const DropReason_SOCKET_LOOKUP_FAILED = flow.DropReason_SOCKET_LOOKUP_FAILED
const DropReason_SOCKET_ASSIGN_FAILED = flow.DropReason_SOCKET_ASSIGN_FAILED
const DropReason_PROXY_REDIRECTION_NOT_SUPPORTED_FOR_PROTOCOL = flow.DropReason_PROXY_REDIRECTION_NOT_SUPPORTED_FOR_PROTOCOL
const DropReason_POLICY_DENY = flow.DropReason_POLICY_DENY
const DropReason_VLAN_FILTERED = flow.DropReason_VLAN_FILTERED
const DropReason_INVALID_VNI = flow.DropReason_INVALID_VNI
const DropReason_INVALID_TC_BUFFER = flow.DropReason_INVALID_TC_BUFFER
const DropReason_NO_SID = flow.DropReason_NO_SID
const DropReason_MISSING_SRV6_STATE = flow.DropReason_MISSING_SRV6_STATE
const DropReason_NAT46 = flow.DropReason_NAT46
const DropReason_NAT64 = flow.DropReason_NAT64
const DropReason_AUTH_REQUIRED = flow.DropReason_AUTH_REQUIRED
const DropReason_CT_NO_MAP_FOUND = flow.DropReason_CT_NO_MAP_FOUND
const DropReason_SNAT_NO_MAP_FOUND = flow.DropReason_SNAT_NO_MAP_FOUND
const DropReason_INVALID_CLUSTER_ID = flow.DropReason_INVALID_CLUSTER_ID
const DropReason_UNSUPPORTED_PROTOCOL_FOR_DSR_ENCAP = flow.DropReason_UNSUPPORTED_PROTOCOL_FOR_DSR_ENCAP
const DropReason_NO_EGRESS_GATEWAY = flow.DropReason_NO_EGRESS_GATEWAY
const DropReason_UNENCRYPTED_TRAFFIC = flow.DropReason_UNENCRYPTED_TRAFFIC
const DropReason_TTL_EXCEEDED = flow.DropReason_TTL_EXCEEDED
const DropReason_NO_NODE_ID = flow.DropReason_NO_NODE_ID
const DropReason_DROP_RATE_LIMITED = flow.DropReason_DROP_RATE_LIMITED
const DropReason_DROP_HOST_NOT_READY = flow.DropReason_DROP_HOST_NOT_READY

var DropReason_name = flow.DropReason_name
var DropReason_value = flow.DropReason_value

type TrafficDirection = flow.TrafficDirection

const TrafficDirection_TRAFFIC_DIRECTION_UNKNOWN = flow.TrafficDirection_TRAFFIC_DIRECTION_UNKNOWN
const TrafficDirection_INGRESS = flow.TrafficDirection_INGRESS
const TrafficDirection_EGRESS = flow.TrafficDirection_EGRESS

var TrafficDirection_name = flow.TrafficDirection_name
var TrafficDirection_value = flow.TrafficDirection_value

type DebugCapturePoint = flow.DebugCapturePoint

const DebugCapturePoint_DBG_CAPTURE_POINT_UNKNOWN = flow.DebugCapturePoint_DBG_CAPTURE_POINT_UNKNOWN
const DebugCapturePoint_DBG_CAPTURE_DELIVERY = flow.DebugCapturePoint_DBG_CAPTURE_DELIVERY
const DebugCapturePoint_DBG_CAPTURE_FROM_LB = flow.DebugCapturePoint_DBG_CAPTURE_FROM_LB
const DebugCapturePoint_DBG_CAPTURE_AFTER_V46 = flow.DebugCapturePoint_DBG_CAPTURE_AFTER_V46
const DebugCapturePoint_DBG_CAPTURE_AFTER_V64 = flow.DebugCapturePoint_DBG_CAPTURE_AFTER_V64
const DebugCapturePoint_DBG_CAPTURE_PROXY_PRE = flow.DebugCapturePoint_DBG_CAPTURE_PROXY_PRE
const DebugCapturePoint_DBG_CAPTURE_PROXY_POST = flow.DebugCapturePoint_DBG_CAPTURE_PROXY_POST
const DebugCapturePoint_DBG_CAPTURE_SNAT_PRE = flow.DebugCapturePoint_DBG_CAPTURE_SNAT_PRE
const DebugCapturePoint_DBG_CAPTURE_SNAT_POST = flow.DebugCapturePoint_DBG_CAPTURE_SNAT_POST

var DebugCapturePoint_name = flow.DebugCapturePoint_name
var DebugCapturePoint_value = flow.DebugCapturePoint_value

type EventType = flow.EventType

const EventType_UNKNOWN = flow.EventType_UNKNOWN
const EventType_EventSample = flow.EventType_EventSample
const EventType_RecordLost = flow.EventType_RecordLost

var EventType_name = flow.EventType_name
var EventType_value = flow.EventType_value

type LostEventSource = flow.LostEventSource

const LostEventSource_UNKNOWN_LOST_EVENT_SOURCE = flow.LostEventSource_UNKNOWN_LOST_EVENT_SOURCE
const LostEventSource_PERF_EVENT_RING_BUFFER = flow.LostEventSource_PERF_EVENT_RING_BUFFER
const LostEventSource_OBSERVER_EVENTS_QUEUE = flow.LostEventSource_OBSERVER_EVENTS_QUEUE
const LostEventSource_HUBBLE_RING_BUFFER = flow.LostEventSource_HUBBLE_RING_BUFFER

var LostEventSource_name = flow.LostEventSource_name
var LostEventSource_value = flow.LostEventSource_value

type AgentEventType = flow.AgentEventType

const AgentEventType_AGENT_EVENT_UNKNOWN = flow.AgentEventType_AGENT_EVENT_UNKNOWN
const AgentEventType_AGENT_STARTED = flow.AgentEventType_AGENT_STARTED
const AgentEventType_POLICY_UPDATED = flow.AgentEventType_POLICY_UPDATED
const AgentEventType_POLICY_DELETED = flow.AgentEventType_POLICY_DELETED
const AgentEventType_ENDPOINT_REGENERATE_SUCCESS = flow.AgentEventType_ENDPOINT_REGENERATE_SUCCESS
const AgentEventType_ENDPOINT_REGENERATE_FAILURE = flow.AgentEventType_ENDPOINT_REGENERATE_FAILURE
const AgentEventType_ENDPOINT_CREATED = flow.AgentEventType_ENDPOINT_CREATED
const AgentEventType_ENDPOINT_DELETED = flow.AgentEventType_ENDPOINT_DELETED
const AgentEventType_IPCACHE_UPSERTED = flow.AgentEventType_IPCACHE_UPSERTED
const AgentEventType_IPCACHE_DELETED = flow.AgentEventType_IPCACHE_DELETED
const AgentEventType_SERVICE_UPSERTED = flow.AgentEventType_SERVICE_UPSERTED
const AgentEventType_SERVICE_DELETED = flow.AgentEventType_SERVICE_DELETED

var AgentEventType_name = flow.AgentEventType_name
var AgentEventType_value = flow.AgentEventType_value

type SocketTranslationPoint = flow.SocketTranslationPoint

const SocketTranslationPoint_SOCK_XLATE_POINT_UNKNOWN = flow.SocketTranslationPoint_SOCK_XLATE_POINT_UNKNOWN
const SocketTranslationPoint_SOCK_XLATE_POINT_PRE_DIRECTION_FWD = flow.SocketTranslationPoint_SOCK_XLATE_POINT_PRE_DIRECTION_FWD
const SocketTranslationPoint_SOCK_XLATE_POINT_POST_DIRECTION_FWD = flow.SocketTranslationPoint_SOCK_XLATE_POINT_POST_DIRECTION_FWD
const SocketTranslationPoint_SOCK_XLATE_POINT_PRE_DIRECTION_REV = flow.SocketTranslationPoint_SOCK_XLATE_POINT_PRE_DIRECTION_REV
const SocketTranslationPoint_SOCK_XLATE_POINT_POST_DIRECTION_REV = flow.SocketTranslationPoint_SOCK_XLATE_POINT_POST_DIRECTION_REV

var SocketTranslationPoint_name = flow.SocketTranslationPoint_name
var SocketTranslationPoint_value = flow.SocketTranslationPoint_value

type DebugEventType = flow.DebugEventType

const DebugEventType_DBG_EVENT_UNKNOWN = flow.DebugEventType_DBG_EVENT_UNKNOWN
const DebugEventType_DBG_GENERIC = flow.DebugEventType_DBG_GENERIC
const DebugEventType_DBG_LOCAL_DELIVERY = flow.DebugEventType_DBG_LOCAL_DELIVERY
const DebugEventType_DBG_ENCAP = flow.DebugEventType_DBG_ENCAP
const DebugEventType_DBG_LXC_FOUND = flow.DebugEventType_DBG_LXC_FOUND
const DebugEventType_DBG_POLICY_DENIED = flow.DebugEventType_DBG_POLICY_DENIED
const DebugEventType_DBG_CT_LOOKUP = flow.DebugEventType_DBG_CT_LOOKUP
const DebugEventType_DBG_CT_LOOKUP_REV = flow.DebugEventType_DBG_CT_LOOKUP_REV
const DebugEventType_DBG_CT_MATCH = flow.DebugEventType_DBG_CT_MATCH
const DebugEventType_DBG_CT_CREATED = flow.DebugEventType_DBG_CT_CREATED
const DebugEventType_DBG_CT_CREATED2 = flow.DebugEventType_DBG_CT_CREATED2
const DebugEventType_DBG_ICMP6_HANDLE = flow.DebugEventType_DBG_ICMP6_HANDLE
const DebugEventType_DBG_ICMP6_REQUEST = flow.DebugEventType_DBG_ICMP6_REQUEST
const DebugEventType_DBG_ICMP6_NS = flow.DebugEventType_DBG_ICMP6_NS
const DebugEventType_DBG_ICMP6_TIME_EXCEEDED = flow.DebugEventType_DBG_ICMP6_TIME_EXCEEDED
const DebugEventType_DBG_CT_VERDICT = flow.DebugEventType_DBG_CT_VERDICT
const DebugEventType_DBG_DECAP = flow.DebugEventType_DBG_DECAP
const DebugEventType_DBG_PORT_MAP = flow.DebugEventType_DBG_PORT_MAP
const DebugEventType_DBG_ERROR_RET = flow.DebugEventType_DBG_ERROR_RET
const DebugEventType_DBG_TO_HOST = flow.DebugEventType_DBG_TO_HOST
const DebugEventType_DBG_TO_STACK = flow.DebugEventType_DBG_TO_STACK
const DebugEventType_DBG_PKT_HASH = flow.DebugEventType_DBG_PKT_HASH
const DebugEventType_DBG_LB6_LOOKUP_FRONTEND = flow.DebugEventType_DBG_LB6_LOOKUP_FRONTEND
const DebugEventType_DBG_LB6_LOOKUP_FRONTEND_FAIL = flow.DebugEventType_DBG_LB6_LOOKUP_FRONTEND_FAIL
const DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT = flow.DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT
const DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT_SUCCESS = flow.DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT_SUCCESS
const DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT_V2_FAIL = flow.DebugEventType_DBG_LB6_LOOKUP_BACKEND_SLOT_V2_FAIL
const DebugEventType_DBG_LB6_LOOKUP_BACKEND_FAIL = flow.DebugEventType_DBG_LB6_LOOKUP_BACKEND_FAIL
const DebugEventType_DBG_LB6_REVERSE_NAT_LOOKUP = flow.DebugEventType_DBG_LB6_REVERSE_NAT_LOOKUP
const DebugEventType_DBG_LB6_REVERSE_NAT = flow.DebugEventType_DBG_LB6_REVERSE_NAT
const DebugEventType_DBG_LB4_LOOKUP_FRONTEND = flow.DebugEventType_DBG_LB4_LOOKUP_FRONTEND
const DebugEventType_DBG_LB4_LOOKUP_FRONTEND_FAIL = flow.DebugEventType_DBG_LB4_LOOKUP_FRONTEND_FAIL
const DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT = flow.DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT
const DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT_SUCCESS = flow.DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT_SUCCESS
const DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT_V2_FAIL = flow.DebugEventType_DBG_LB4_LOOKUP_BACKEND_SLOT_V2_FAIL
const DebugEventType_DBG_LB4_LOOKUP_BACKEND_FAIL = flow.DebugEventType_DBG_LB4_LOOKUP_BACKEND_FAIL
const DebugEventType_DBG_LB4_REVERSE_NAT_LOOKUP = flow.DebugEventType_DBG_LB4_REVERSE_NAT_LOOKUP
const DebugEventType_DBG_LB4_REVERSE_NAT = flow.DebugEventType_DBG_LB4_REVERSE_NAT
const DebugEventType_DBG_LB4_LOOPBACK_SNAT = flow.DebugEventType_DBG_LB4_LOOPBACK_SNAT
const DebugEventType_DBG_LB4_LOOPBACK_SNAT_REV = flow.DebugEventType_DBG_LB4_LOOPBACK_SNAT_REV
const DebugEventType_DBG_CT_LOOKUP4 = flow.DebugEventType_DBG_CT_LOOKUP4
const DebugEventType_DBG_RR_BACKEND_SLOT_SEL = flow.DebugEventType_DBG_RR_BACKEND_SLOT_SEL
const DebugEventType_DBG_REV_PROXY_LOOKUP = flow.DebugEventType_DBG_REV_PROXY_LOOKUP
const DebugEventType_DBG_REV_PROXY_FOUND = flow.DebugEventType_DBG_REV_PROXY_FOUND
const DebugEventType_DBG_REV_PROXY_UPDATE = flow.DebugEventType_DBG_REV_PROXY_UPDATE
const DebugEventType_DBG_L4_POLICY = flow.DebugEventType_DBG_L4_POLICY
const DebugEventType_DBG_NETDEV_IN_CLUSTER = flow.DebugEventType_DBG_NETDEV_IN_CLUSTER
const DebugEventType_DBG_NETDEV_ENCAP4 = flow.DebugEventType_DBG_NETDEV_ENCAP4
const DebugEventType_DBG_CT_LOOKUP4_1 = flow.DebugEventType_DBG_CT_LOOKUP4_1
const DebugEventType_DBG_CT_LOOKUP4_2 = flow.DebugEventType_DBG_CT_LOOKUP4_2
const DebugEventType_DBG_CT_CREATED4 = flow.DebugEventType_DBG_CT_CREATED4
const DebugEventType_DBG_CT_LOOKUP6_1 = flow.DebugEventType_DBG_CT_LOOKUP6_1
const DebugEventType_DBG_CT_LOOKUP6_2 = flow.DebugEventType_DBG_CT_LOOKUP6_2
const DebugEventType_DBG_CT_CREATED6 = flow.DebugEventType_DBG_CT_CREATED6
const DebugEventType_DBG_SKIP_PROXY = flow.DebugEventType_DBG_SKIP_PROXY
const DebugEventType_DBG_L4_CREATE = flow.DebugEventType_DBG_L4_CREATE
const DebugEventType_DBG_IP_ID_MAP_FAILED4 = flow.DebugEventType_DBG_IP_ID_MAP_FAILED4
const DebugEventType_DBG_IP_ID_MAP_FAILED6 = flow.DebugEventType_DBG_IP_ID_MAP_FAILED6
const DebugEventType_DBG_IP_ID_MAP_SUCCEED4 = flow.DebugEventType_DBG_IP_ID_MAP_SUCCEED4
const DebugEventType_DBG_IP_ID_MAP_SUCCEED6 = flow.DebugEventType_DBG_IP_ID_MAP_SUCCEED6
const DebugEventType_DBG_LB_STALE_CT = flow.DebugEventType_DBG_LB_STALE_CT
const DebugEventType_DBG_INHERIT_IDENTITY = flow.DebugEventType_DBG_INHERIT_IDENTITY
const DebugEventType_DBG_SK_LOOKUP4 = flow.DebugEventType_DBG_SK_LOOKUP4
const DebugEventType_DBG_SK_LOOKUP6 = flow.DebugEventType_DBG_SK_LOOKUP6
const DebugEventType_DBG_SK_ASSIGN = flow.DebugEventType_DBG_SK_ASSIGN
const DebugEventType_DBG_L7_LB = flow.DebugEventType_DBG_L7_LB
const DebugEventType_DBG_SKIP_POLICY = flow.DebugEventType_DBG_SKIP_POLICY

var DebugEventType_name = flow.DebugEventType_name
var DebugEventType_value = flow.DebugEventType_value

type Flow = flow.Flow
type Layer4 = flow.Layer4
type Layer4_TCP = flow.Layer4_TCP
type Layer4_UDP = flow.Layer4_UDP
type Layer4_ICMPv4 = flow.Layer4_ICMPv4
type Layer4_ICMPv6 = flow.Layer4_ICMPv6
type Layer4_SCTP = flow.Layer4_SCTP
type Layer7 = flow.Layer7
type Layer7_Dns = flow.Layer7_Dns
type Layer7_Http = flow.Layer7_Http
type Layer7_Kafka = flow.Layer7_Kafka
type TraceContext = flow.TraceContext
type TraceParent = flow.TraceParent
type Endpoint = flow.Endpoint
type Workload = flow.Workload
type TCP = flow.TCP
type IP = flow.IP
type Ethernet = flow.Ethernet
type TCPFlags = flow.TCPFlags
type UDP = flow.UDP
type SCTP = flow.SCTP
type ICMPv4 = flow.ICMPv4
type ICMPv6 = flow.ICMPv6
type Policy = flow.Policy
type EventTypeFilter = flow.EventTypeFilter
type CiliumEventType = flow.CiliumEventType
type FlowFilter = flow.FlowFilter
type DNS = flow.DNS
type HTTPHeader = flow.HTTPHeader
type HTTP = flow.HTTP
type Kafka = flow.Kafka
type Service = flow.Service
type LostEvent = flow.LostEvent
type AgentEvent = flow.AgentEvent
type AgentEvent_Unknown = flow.AgentEvent_Unknown
type AgentEvent_AgentStart = flow.AgentEvent_AgentStart
type AgentEvent_PolicyUpdate = flow.AgentEvent_PolicyUpdate
type AgentEvent_EndpointRegenerate = flow.AgentEvent_EndpointRegenerate
type AgentEvent_EndpointUpdate = flow.AgentEvent_EndpointUpdate
type AgentEvent_IpcacheUpdate = flow.AgentEvent_IpcacheUpdate
type AgentEvent_ServiceUpsert = flow.AgentEvent_ServiceUpsert
type AgentEvent_ServiceDelete = flow.AgentEvent_ServiceDelete
type AgentEventUnknown = flow.AgentEventUnknown
type TimeNotification = flow.TimeNotification
type PolicyUpdateNotification = flow.PolicyUpdateNotification
type EndpointRegenNotification = flow.EndpointRegenNotification
type EndpointUpdateNotification = flow.EndpointUpdateNotification
type IPCacheNotification = flow.IPCacheNotification
type ServiceUpsertNotificationAddr = flow.ServiceUpsertNotificationAddr
type ServiceUpsertNotification = flow.ServiceUpsertNotification
type ServiceDeleteNotification = flow.ServiceDeleteNotification
type NetworkInterface = flow.NetworkInterface
type DebugEvent = flow.DebugEvent

type ServerStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ServerStatusRequest) Reset() {
	*x = ServerStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerStatusRequest) ProtoMessage() {}

func (x *ServerStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerStatusRequest.ProtoReflect.Descriptor instead.
func (*ServerStatusRequest) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{0}
}

type ServerStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// number of currently captured flows
	// In a multi-node context, this is the cumulative count of all captured
	// flows.
	NumFlows uint64 `protobuf:"varint,1,opt,name=num_flows,json=numFlows,proto3" json:"num_flows,omitempty"`
	// maximum capacity of the ring buffer
	// In a multi-node context, this is the aggregation of all ring buffers
	// capacities.
	MaxFlows uint64 `protobuf:"varint,2,opt,name=max_flows,json=maxFlows,proto3" json:"max_flows,omitempty"`
	// total amount of flows observed since the observer was started
	// In a multi-node context, this is the aggregation of all flows that have
	// been seen.
	SeenFlows uint64 `protobuf:"varint,3,opt,name=seen_flows,json=seenFlows,proto3" json:"seen_flows,omitempty"`
	// uptime of this observer instance in nanoseconds
	// In a multi-node context, this field corresponds to the uptime of the
	// longest living instance.
	UptimeNs uint64 `protobuf:"varint,4,opt,name=uptime_ns,json=uptimeNs,proto3" json:"uptime_ns,omitempty"`
	// number of nodes for which a connection is established
	NumConnectedNodes *wrapperspb.UInt32Value `protobuf:"bytes,5,opt,name=num_connected_nodes,json=numConnectedNodes,proto3" json:"num_connected_nodes,omitempty"`
	// number of nodes for which a connection cannot be established
	NumUnavailableNodes *wrapperspb.UInt32Value `protobuf:"bytes,6,opt,name=num_unavailable_nodes,json=numUnavailableNodes,proto3" json:"num_unavailable_nodes,omitempty"`
	// list of nodes that are unavailable
	// This list may not be exhaustive.
	UnavailableNodes []string `protobuf:"bytes,7,rep,name=unavailable_nodes,json=unavailableNodes,proto3" json:"unavailable_nodes,omitempty"`
	// Version is the version of Cilium/Hubble.
	Version string `protobuf:"bytes,8,opt,name=version,proto3" json:"version,omitempty"`
	// Approximate rate of flows seen by Hubble per second over the last minute.
	// In a multi-node context, this is the sum of all flows rates.
	FlowsRate float64 `protobuf:"fixed64,9,opt,name=flows_rate,json=flowsRate,proto3" json:"flows_rate,omitempty"`
}

func (x *ServerStatusResponse) Reset() {
	*x = ServerStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerStatusResponse) ProtoMessage() {}

func (x *ServerStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerStatusResponse.ProtoReflect.Descriptor instead.
func (*ServerStatusResponse) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{1}
}

func (x *ServerStatusResponse) GetNumFlows() uint64 {
	if x != nil {
		return x.NumFlows
	}
	return 0
}

func (x *ServerStatusResponse) GetMaxFlows() uint64 {
	if x != nil {
		return x.MaxFlows
	}
	return 0
}

func (x *ServerStatusResponse) GetSeenFlows() uint64 {
	if x != nil {
		return x.SeenFlows
	}
	return 0
}

func (x *ServerStatusResponse) GetUptimeNs() uint64 {
	if x != nil {
		return x.UptimeNs
	}
	return 0
}

func (x *ServerStatusResponse) GetNumConnectedNodes() *wrapperspb.UInt32Value {
	if x != nil {
		return x.NumConnectedNodes
	}
	return nil
}

func (x *ServerStatusResponse) GetNumUnavailableNodes() *wrapperspb.UInt32Value {
	if x != nil {
		return x.NumUnavailableNodes
	}
	return nil
}

func (x *ServerStatusResponse) GetUnavailableNodes() []string {
	if x != nil {
		return x.UnavailableNodes
	}
	return nil
}

func (x *ServerStatusResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ServerStatusResponse) GetFlowsRate() float64 {
	if x != nil {
		return x.FlowsRate
	}
	return 0
}

type GetFlowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of flows that should be returned. Incompatible with `since/until`.
	// Defaults to the most recent (last) `number` flows, unless `first` is
	// true, then it will return the earliest `number` flows.
	Number uint64 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// first specifies if we should look at the first `number` flows or the
	// last `number` of flows. Incompatible with `follow`.
	First bool `protobuf:"varint,9,opt,name=first,proto3" json:"first,omitempty"`
	// follow sets when the server should continue to stream flows after
	// printing the last N flows.
	Follow bool `protobuf:"varint,3,opt,name=follow,proto3" json:"follow,omitempty"`
	// blacklist defines a list of filters which have to match for a flow to be
	// excluded from the result.
	// If multiple blacklist filters are specified, only one of them has to
	// match for a flow to be excluded.
	Blacklist []*flow.FlowFilter `protobuf:"bytes,5,rep,name=blacklist,proto3" json:"blacklist,omitempty"`
	// whitelist defines a list of filters which have to match for a flow to be
	// included in the result.
	// If multiple whitelist filters are specified, only one of them has to
	// match for a flow to be included.
	// The whitelist and blacklist can both be specified. In such cases, the
	// set of the returned flows is the set difference `whitelist - blacklist`.
	// In other words, the result will contain all flows matched by the
	// whitelist that are not also simultaneously matched by the blacklist.
	Whitelist []*flow.FlowFilter `protobuf:"bytes,6,rep,name=whitelist,proto3" json:"whitelist,omitempty"`
	// Since this time for returned flows. Incompatible with `number`.
	Since *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=since,proto3" json:"since,omitempty"`
	// Until this time for returned flows. Incompatible with `number`.
	Until        *timestamppb.Timestamp        `protobuf:"bytes,8,opt,name=until,proto3" json:"until,omitempty"`
	Experimental *GetFlowsRequest_Experimental `protobuf:"bytes,999,opt,name=experimental,proto3" json:"experimental,omitempty"`
	// extensions can be used to add arbitrary additional metadata to GetFlowsRequest.
	// This can be used to extend functionality for other Hubble compatible
	// APIs, or experiment with new functionality without needing to change the public API.
	Extensions *anypb.Any `protobuf:"bytes,150000,opt,name=extensions,proto3" json:"extensions,omitempty"`
}

func (x *GetFlowsRequest) Reset() {
	*x = GetFlowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFlowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFlowsRequest) ProtoMessage() {}

func (x *GetFlowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFlowsRequest.ProtoReflect.Descriptor instead.
func (*GetFlowsRequest) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{2}
}

func (x *GetFlowsRequest) GetNumber() uint64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *GetFlowsRequest) GetFirst() bool {
	if x != nil {
		return x.First
	}
	return false
}

func (x *GetFlowsRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

func (x *GetFlowsRequest) GetBlacklist() []*flow.FlowFilter {
	if x != nil {
		return x.Blacklist
	}
	return nil
}

func (x *GetFlowsRequest) GetWhitelist() []*flow.FlowFilter {
	if x != nil {
		return x.Whitelist
	}
	return nil
}

func (x *GetFlowsRequest) GetSince() *timestamppb.Timestamp {
	if x != nil {
		return x.Since
	}
	return nil
}

func (x *GetFlowsRequest) GetUntil() *timestamppb.Timestamp {
	if x != nil {
		return x.Until
	}
	return nil
}

func (x *GetFlowsRequest) GetExperimental() *GetFlowsRequest_Experimental {
	if x != nil {
		return x.Experimental
	}
	return nil
}

func (x *GetFlowsRequest) GetExtensions() *anypb.Any {
	if x != nil {
		return x.Extensions
	}
	return nil
}

// GetFlowsResponse contains either a flow or a protocol message.
type GetFlowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ResponseTypes:
	//
	//	*GetFlowsResponse_Flow
	//	*GetFlowsResponse_NodeStatus
	//	*GetFlowsResponse_LostEvents
	ResponseTypes isGetFlowsResponse_ResponseTypes `protobuf_oneof:"response_types"`
	// Name of the node where this event was observed.
	NodeName string `protobuf:"bytes,1000,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// Timestamp at which this event was observed.
	Time *timestamppb.Timestamp `protobuf:"bytes,1001,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *GetFlowsResponse) Reset() {
	*x = GetFlowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFlowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFlowsResponse) ProtoMessage() {}

func (x *GetFlowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFlowsResponse.ProtoReflect.Descriptor instead.
func (*GetFlowsResponse) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{3}
}

func (m *GetFlowsResponse) GetResponseTypes() isGetFlowsResponse_ResponseTypes {
	if m != nil {
		return m.ResponseTypes
	}
	return nil
}

func (x *GetFlowsResponse) GetFlow() *flow.Flow {
	if x, ok := x.GetResponseTypes().(*GetFlowsResponse_Flow); ok {
		return x.Flow
	}
	return nil
}

func (x *GetFlowsResponse) GetNodeStatus() *relay.NodeStatusEvent {
	if x, ok := x.GetResponseTypes().(*GetFlowsResponse_NodeStatus); ok {
		return x.NodeStatus
	}
	return nil
}

func (x *GetFlowsResponse) GetLostEvents() *flow.LostEvent {
	if x, ok := x.GetResponseTypes().(*GetFlowsResponse_LostEvents); ok {
		return x.LostEvents
	}
	return nil
}

func (x *GetFlowsResponse) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *GetFlowsResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type isGetFlowsResponse_ResponseTypes interface {
	isGetFlowsResponse_ResponseTypes()
}

type GetFlowsResponse_Flow struct {
	Flow *flow.Flow `protobuf:"bytes,1,opt,name=flow,proto3,oneof"`
}

type GetFlowsResponse_NodeStatus struct {
	// node_status informs clients about the state of the nodes
	// participating in this particular GetFlows request.
	NodeStatus *relay.NodeStatusEvent `protobuf:"bytes,2,opt,name=node_status,json=nodeStatus,proto3,oneof"`
}

type GetFlowsResponse_LostEvents struct {
	// lost_events informs clients about events which got dropped due to
	// a Hubble component being unavailable
	LostEvents *flow.LostEvent `protobuf:"bytes,3,opt,name=lost_events,json=lostEvents,proto3,oneof"`
}

func (*GetFlowsResponse_Flow) isGetFlowsResponse_ResponseTypes() {}

func (*GetFlowsResponse_NodeStatus) isGetFlowsResponse_ResponseTypes() {}

func (*GetFlowsResponse_LostEvents) isGetFlowsResponse_ResponseTypes() {}

type GetAgentEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of flows that should be returned. Incompatible with `since/until`.
	// Defaults to the most recent (last) `number` events, unless `first` is
	// true, then it will return the earliest `number` events.
	Number uint64 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// first specifies if we should look at the first `number` events or the
	// last `number` of events. Incompatible with `follow`.
	First bool `protobuf:"varint,9,opt,name=first,proto3" json:"first,omitempty"`
	// follow sets when the server should continue to stream agent events after
	// printing the last N agent events.
	Follow bool `protobuf:"varint,2,opt,name=follow,proto3" json:"follow,omitempty"`
	// Since this time for returned agent events. Incompatible with `number`.
	Since *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=since,proto3" json:"since,omitempty"`
	// Until this time for returned agent events. Incompatible with `number`.
	Until *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=until,proto3" json:"until,omitempty"`
}

func (x *GetAgentEventsRequest) Reset() {
	*x = GetAgentEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAgentEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentEventsRequest) ProtoMessage() {}

func (x *GetAgentEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentEventsRequest.ProtoReflect.Descriptor instead.
func (*GetAgentEventsRequest) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{4}
}

func (x *GetAgentEventsRequest) GetNumber() uint64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *GetAgentEventsRequest) GetFirst() bool {
	if x != nil {
		return x.First
	}
	return false
}

func (x *GetAgentEventsRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

func (x *GetAgentEventsRequest) GetSince() *timestamppb.Timestamp {
	if x != nil {
		return x.Since
	}
	return nil
}

func (x *GetAgentEventsRequest) GetUntil() *timestamppb.Timestamp {
	if x != nil {
		return x.Until
	}
	return nil
}

// GetAgentEventsResponse contains an event received from the Cilium agent.
type GetAgentEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AgentEvent *flow.AgentEvent `protobuf:"bytes,1,opt,name=agent_event,json=agentEvent,proto3" json:"agent_event,omitempty"`
	// Name of the node where this event was observed.
	NodeName string `protobuf:"bytes,1000,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// Timestamp at which this event was observed.
	Time *timestamppb.Timestamp `protobuf:"bytes,1001,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *GetAgentEventsResponse) Reset() {
	*x = GetAgentEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAgentEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAgentEventsResponse) ProtoMessage() {}

func (x *GetAgentEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAgentEventsResponse.ProtoReflect.Descriptor instead.
func (*GetAgentEventsResponse) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{5}
}

func (x *GetAgentEventsResponse) GetAgentEvent() *flow.AgentEvent {
	if x != nil {
		return x.AgentEvent
	}
	return nil
}

func (x *GetAgentEventsResponse) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *GetAgentEventsResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type GetDebugEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of events that should be returned. Incompatible with `since/until`.
	// Defaults to the most recent (last) `number` events, unless `first` is
	// true, then it will return the earliest `number` events.
	Number uint64 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// first specifies if we should look at the first `number` events or the
	// last `number` of events. Incompatible with `follow`.
	First bool `protobuf:"varint,9,opt,name=first,proto3" json:"first,omitempty"`
	// follow sets when the server should continue to stream debug events after
	// printing the last N debug events.
	Follow bool `protobuf:"varint,2,opt,name=follow,proto3" json:"follow,omitempty"`
	// Since this time for returned debug events. Incompatible with `number`.
	Since *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=since,proto3" json:"since,omitempty"`
	// Until this time for returned debug events. Incompatible with `number`.
	Until *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=until,proto3" json:"until,omitempty"`
}

func (x *GetDebugEventsRequest) Reset() {
	*x = GetDebugEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDebugEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDebugEventsRequest) ProtoMessage() {}

func (x *GetDebugEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDebugEventsRequest.ProtoReflect.Descriptor instead.
func (*GetDebugEventsRequest) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{6}
}

func (x *GetDebugEventsRequest) GetNumber() uint64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *GetDebugEventsRequest) GetFirst() bool {
	if x != nil {
		return x.First
	}
	return false
}

func (x *GetDebugEventsRequest) GetFollow() bool {
	if x != nil {
		return x.Follow
	}
	return false
}

func (x *GetDebugEventsRequest) GetSince() *timestamppb.Timestamp {
	if x != nil {
		return x.Since
	}
	return nil
}

func (x *GetDebugEventsRequest) GetUntil() *timestamppb.Timestamp {
	if x != nil {
		return x.Until
	}
	return nil
}

// GetDebugEventsResponse contains a Cilium datapath debug events.
type GetDebugEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DebugEvent *flow.DebugEvent `protobuf:"bytes,1,opt,name=debug_event,json=debugEvent,proto3" json:"debug_event,omitempty"`
	// Name of the node where this event was observed.
	NodeName string `protobuf:"bytes,1000,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// Timestamp at which this event was observed.
	Time *timestamppb.Timestamp `protobuf:"bytes,1001,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *GetDebugEventsResponse) Reset() {
	*x = GetDebugEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDebugEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDebugEventsResponse) ProtoMessage() {}

func (x *GetDebugEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDebugEventsResponse.ProtoReflect.Descriptor instead.
func (*GetDebugEventsResponse) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{7}
}

func (x *GetDebugEventsResponse) GetDebugEvent() *flow.DebugEvent {
	if x != nil {
		return x.DebugEvent
	}
	return nil
}

func (x *GetDebugEventsResponse) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *GetDebugEventsResponse) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type GetNodesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetNodesRequest) Reset() {
	*x = GetNodesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodesRequest) ProtoMessage() {}

func (x *GetNodesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodesRequest.ProtoReflect.Descriptor instead.
func (*GetNodesRequest) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{8}
}

// GetNodesResponse contains the list of nodes.
type GetNodesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Nodes is an exhaustive list of nodes.
	Nodes []*Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
}

func (x *GetNodesResponse) Reset() {
	*x = GetNodesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodesResponse) ProtoMessage() {}

func (x *GetNodesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodesResponse.ProtoReflect.Descriptor instead.
func (*GetNodesResponse) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{9}
}

func (x *GetNodesResponse) GetNodes() []*Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// Node represents a cluster node.
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name is the name of the node.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version is the version of Cilium/Hubble as reported by the node.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Address is the network address of the API endpoint.
	Address string `protobuf:"bytes,3,opt,name=address,proto3" json:"address,omitempty"`
	// State represents the known state of the node.
	State relay.NodeState `protobuf:"varint,4,opt,name=state,proto3,enum=relay.NodeState" json:"state,omitempty"`
	// TLS reports TLS related information.
	Tls *TLS `protobuf:"bytes,5,opt,name=tls,proto3" json:"tls,omitempty"`
	// UptimeNS is the uptime of this instance in nanoseconds
	UptimeNs uint64 `protobuf:"varint,6,opt,name=uptime_ns,json=uptimeNs,proto3" json:"uptime_ns,omitempty"`
	// number of currently captured flows
	NumFlows uint64 `protobuf:"varint,7,opt,name=num_flows,json=numFlows,proto3" json:"num_flows,omitempty"`
	// maximum capacity of the ring buffer
	MaxFlows uint64 `protobuf:"varint,8,opt,name=max_flows,json=maxFlows,proto3" json:"max_flows,omitempty"`
	// total amount of flows observed since the observer was started
	SeenFlows uint64 `protobuf:"varint,9,opt,name=seen_flows,json=seenFlows,proto3" json:"seen_flows,omitempty"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{10}
}

func (x *Node) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Node) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Node) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Node) GetState() relay.NodeState {
	if x != nil {
		return x.State
	}
	return relay.NodeState(0)
}

func (x *Node) GetTls() *TLS {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *Node) GetUptimeNs() uint64 {
	if x != nil {
		return x.UptimeNs
	}
	return 0
}

func (x *Node) GetNumFlows() uint64 {
	if x != nil {
		return x.NumFlows
	}
	return 0
}

func (x *Node) GetMaxFlows() uint64 {
	if x != nil {
		return x.MaxFlows
	}
	return 0
}

func (x *Node) GetSeenFlows() uint64 {
	if x != nil {
		return x.SeenFlows
	}
	return 0
}

// TLS represents TLS information.
type TLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enabled reports whether TLS is enabled or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// ServerName is the TLS server name that can be used as part of the TLS
	// cert validation process.
	ServerName string `protobuf:"bytes,2,opt,name=server_name,json=serverName,proto3" json:"server_name,omitempty"`
}

func (x *TLS) Reset() {
	*x = TLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLS) ProtoMessage() {}

func (x *TLS) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLS.ProtoReflect.Descriptor instead.
func (*TLS) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{11}
}

func (x *TLS) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *TLS) GetServerName() string {
	if x != nil {
		return x.ServerName
	}
	return ""
}

type GetNamespacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetNamespacesRequest) Reset() {
	*x = GetNamespacesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNamespacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNamespacesRequest) ProtoMessage() {}

func (x *GetNamespacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNamespacesRequest.ProtoReflect.Descriptor instead.
func (*GetNamespacesRequest) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{12}
}

// GetNamespacesResponse contains the list of namespaces.
type GetNamespacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Namespaces is a list of namespaces with flows
	Namespaces []*Namespace `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
}

func (x *GetNamespacesResponse) Reset() {
	*x = GetNamespacesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNamespacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNamespacesResponse) ProtoMessage() {}

func (x *GetNamespacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNamespacesResponse.ProtoReflect.Descriptor instead.
func (*GetNamespacesResponse) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{13}
}

func (x *GetNamespacesResponse) GetNamespaces() []*Namespace {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

type Namespace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cluster   string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (x *Namespace) Reset() {
	*x = Namespace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Namespace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Namespace) ProtoMessage() {}

func (x *Namespace) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Namespace.ProtoReflect.Descriptor instead.
func (*Namespace) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{14}
}

func (x *Namespace) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *Namespace) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// ExportEvent contains an event to be exported. Not to be used outside of the
// exporter feature.
type ExportEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ResponseTypes:
	//
	//	*ExportEvent_Flow
	//	*ExportEvent_NodeStatus
	//	*ExportEvent_LostEvents
	//	*ExportEvent_AgentEvent
	//	*ExportEvent_DebugEvent
	ResponseTypes isExportEvent_ResponseTypes `protobuf_oneof:"response_types"`
	// Name of the node where this event was observed.
	NodeName string `protobuf:"bytes,1000,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// Timestamp at which this event was observed.
	Time *timestamppb.Timestamp `protobuf:"bytes,1001,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *ExportEvent) Reset() {
	*x = ExportEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEvent) ProtoMessage() {}

func (x *ExportEvent) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEvent.ProtoReflect.Descriptor instead.
func (*ExportEvent) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{15}
}

func (m *ExportEvent) GetResponseTypes() isExportEvent_ResponseTypes {
	if m != nil {
		return m.ResponseTypes
	}
	return nil
}

func (x *ExportEvent) GetFlow() *flow.Flow {
	if x, ok := x.GetResponseTypes().(*ExportEvent_Flow); ok {
		return x.Flow
	}
	return nil
}

func (x *ExportEvent) GetNodeStatus() *relay.NodeStatusEvent {
	if x, ok := x.GetResponseTypes().(*ExportEvent_NodeStatus); ok {
		return x.NodeStatus
	}
	return nil
}

func (x *ExportEvent) GetLostEvents() *flow.LostEvent {
	if x, ok := x.GetResponseTypes().(*ExportEvent_LostEvents); ok {
		return x.LostEvents
	}
	return nil
}

func (x *ExportEvent) GetAgentEvent() *flow.AgentEvent {
	if x, ok := x.GetResponseTypes().(*ExportEvent_AgentEvent); ok {
		return x.AgentEvent
	}
	return nil
}

func (x *ExportEvent) GetDebugEvent() *flow.DebugEvent {
	if x, ok := x.GetResponseTypes().(*ExportEvent_DebugEvent); ok {
		return x.DebugEvent
	}
	return nil
}

func (x *ExportEvent) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *ExportEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type isExportEvent_ResponseTypes interface {
	isExportEvent_ResponseTypes()
}

type ExportEvent_Flow struct {
	Flow *flow.Flow `protobuf:"bytes,1,opt,name=flow,proto3,oneof"`
}

type ExportEvent_NodeStatus struct {
	// node_status informs clients about the state of the nodes
	// participating in this particular GetFlows request.
	NodeStatus *relay.NodeStatusEvent `protobuf:"bytes,2,opt,name=node_status,json=nodeStatus,proto3,oneof"`
}

type ExportEvent_LostEvents struct {
	// lost_events informs clients about events which got dropped due to
	// a Hubble component being unavailable
	LostEvents *flow.LostEvent `protobuf:"bytes,3,opt,name=lost_events,json=lostEvents,proto3,oneof"`
}

type ExportEvent_AgentEvent struct {
	// agent_event informs clients about an event received from the Cilium
	// agent.
	AgentEvent *flow.AgentEvent `protobuf:"bytes,4,opt,name=agent_event,json=agentEvent,proto3,oneof"`
}

type ExportEvent_DebugEvent struct {
	// debug_event contains Cilium datapath debug events
	DebugEvent *flow.DebugEvent `protobuf:"bytes,5,opt,name=debug_event,json=debugEvent,proto3,oneof"`
}

func (*ExportEvent_Flow) isExportEvent_ResponseTypes() {}

func (*ExportEvent_NodeStatus) isExportEvent_ResponseTypes() {}

func (*ExportEvent_LostEvents) isExportEvent_ResponseTypes() {}

func (*ExportEvent_AgentEvent) isExportEvent_ResponseTypes() {}

func (*ExportEvent_DebugEvent) isExportEvent_ResponseTypes() {}

// Experimental contains fields that are not stable yet. Support for
// experimental features is always optional and subject to change.
type GetFlowsRequest_Experimental struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// FieldMask allows clients to limit flow's fields that will be returned.
	// For example, {paths: ["source.id", "destination.id"]} will return flows
	// with only these two fields set.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetFlowsRequest_Experimental) Reset() {
	*x = GetFlowsRequest_Experimental{}
	if protoimpl.UnsafeEnabled {
		mi := &file_observer_observer_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFlowsRequest_Experimental) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFlowsRequest_Experimental) ProtoMessage() {}

func (x *GetFlowsRequest_Experimental) ProtoReflect() protoreflect.Message {
	mi := &file_observer_observer_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFlowsRequest_Experimental.ProtoReflect.Descriptor instead.
func (*GetFlowsRequest_Experimental) Descriptor() ([]byte, []int) {
	return file_observer_observer_proto_rawDescGZIP(), []int{2, 0}
}

func (x *GetFlowsRequest_Experimental) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

var File_observer_observer_proto protoreflect.FileDescriptor

var file_observer_observer_proto_rawDesc = []byte{
	0x0a, 0x17, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2f, 0x6f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x6f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x2f, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x92, 0x03, 0x0a,
	0x14, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x66, 0x6c, 0x6f,
	0x77, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x46, 0x6c, 0x6f,
	0x77, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x09, 0x73, 0x65, 0x65, 0x6e, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x08, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x4e, 0x73, 0x12, 0x4c, 0x0a, 0x13, 0x6e,
	0x75, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x6e, 0x75, 0x6d, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x15, 0x6e, 0x75, 0x6d,
	0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x55, 0x6e, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x75,
	0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x52, 0x61, 0x74,
	0x65, 0x22, 0xf1, 0x03, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x14, 0x0a,
	0x05, 0x66, 0x69, 0x72, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x69,
	0x72, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x12, 0x2e, 0x0a, 0x09, 0x62,
	0x6c, 0x61, 0x63, 0x6b, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x09, 0x62, 0x6c, 0x61, 0x63, 0x6b, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x2e, 0x0a, 0x09, 0x77,
	0x68, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x09, 0x77, 0x68, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x73,
	0x69, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x12, 0x30, 0x0a,
	0x05, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x12,
	0x4b, 0x0a, 0x0c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x18,
	0xe7, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x52, 0x0c,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x12, 0x36, 0x0a, 0x0a,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xf0, 0x93, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x49, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x4a,
	0x04, 0x08, 0x02, 0x10, 0x03, 0x22, 0x84, 0x02, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x0a, 0x04, 0x66, 0x6c,
	0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x46, 0x6c, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x39, 0x0a, 0x0b,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x32, 0x0a, 0x0b, 0x6c, 0x6f, 0x73, 0x74, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x4c, 0x6f, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x0a, 0x6c, 0x6f, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x22, 0xc1, 0x01, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x66, 0x69, 0x72, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66,
	0x69, 0x72, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x12, 0x30, 0x0a, 0x05,
	0x73, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x12, 0x30,
	0x0a, 0x05, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x75, 0x6e, 0x74, 0x69, 0x6c,
	0x22, 0x9a, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x0b, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x10, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1c,
	0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0xe8, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc1, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x14, 0x0a, 0x05, 0x66, 0x69, 0x72, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x12, 0x30, 0x0a,
	0x05, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x12,
	0x30, 0x0a, 0x05, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x75, 0x6e, 0x74, 0x69,
	0x6c, 0x22, 0x9a, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x0b,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0xe8, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x11,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x38, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x8d, 0x02, 0x0a, 0x04,
	0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x26, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x72, 0x65,
	0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0d, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x54, 0x4c, 0x53,
	0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65,
	0x4e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12,
	0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x73, 0x65, 0x65, 0x6e, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x22, 0x40, 0x0a, 0x03, 0x54,
	0x4c, 0x53, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x16, 0x0a,
	0x14, 0x47, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x4c, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33,
	0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x22, 0x43, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0xe9, 0x02, 0x0a, 0x0b, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x46, 0x6c,
	0x6f, 0x77, 0x48, 0x00, 0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x39, 0x0a, 0x0b, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x32, 0x0a, 0x0b, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x4c, 0x6f, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6c,
	0x6f, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x0b, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x33,
	0x0a, 0x0b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x2f, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x32, 0xed, 0x03, 0x0a, 0x08, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x12, 0x45, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x19, 0x2e,
	0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x57, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x2e, 0x6f, 0x62, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x6f, 0x62,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30,
	0x01, 0x12, 0x57, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x1f, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x43, 0x0a, 0x08, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x19, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1a, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x52, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x12, 0x1e, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x47, 0x65, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x4f, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x1d, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x42, 0x2a, 0x5a, 0x28, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2f, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x50, 0x04, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_observer_observer_proto_rawDescOnce sync.Once
	file_observer_observer_proto_rawDescData = file_observer_observer_proto_rawDesc
)

func file_observer_observer_proto_rawDescGZIP() []byte {
	file_observer_observer_proto_rawDescOnce.Do(func() {
		file_observer_observer_proto_rawDescData = protoimpl.X.CompressGZIP(file_observer_observer_proto_rawDescData)
	})
	return file_observer_observer_proto_rawDescData
}

var file_observer_observer_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_observer_observer_proto_goTypes = []interface{}{
	(*ServerStatusRequest)(nil),          // 0: observer.ServerStatusRequest
	(*ServerStatusResponse)(nil),         // 1: observer.ServerStatusResponse
	(*GetFlowsRequest)(nil),              // 2: observer.GetFlowsRequest
	(*GetFlowsResponse)(nil),             // 3: observer.GetFlowsResponse
	(*GetAgentEventsRequest)(nil),        // 4: observer.GetAgentEventsRequest
	(*GetAgentEventsResponse)(nil),       // 5: observer.GetAgentEventsResponse
	(*GetDebugEventsRequest)(nil),        // 6: observer.GetDebugEventsRequest
	(*GetDebugEventsResponse)(nil),       // 7: observer.GetDebugEventsResponse
	(*GetNodesRequest)(nil),              // 8: observer.GetNodesRequest
	(*GetNodesResponse)(nil),             // 9: observer.GetNodesResponse
	(*Node)(nil),                         // 10: observer.Node
	(*TLS)(nil),                          // 11: observer.TLS
	(*GetNamespacesRequest)(nil),         // 12: observer.GetNamespacesRequest
	(*GetNamespacesResponse)(nil),        // 13: observer.GetNamespacesResponse
	(*Namespace)(nil),                    // 14: observer.Namespace
	(*ExportEvent)(nil),                  // 15: observer.ExportEvent
	(*GetFlowsRequest_Experimental)(nil), // 16: observer.GetFlowsRequest.Experimental
	(*wrapperspb.UInt32Value)(nil),       // 17: google.protobuf.UInt32Value
	(*flow.FlowFilter)(nil),              // 18: flow.FlowFilter
	(*timestamppb.Timestamp)(nil),        // 19: google.protobuf.Timestamp
	(*anypb.Any)(nil),                    // 20: google.protobuf.Any
	(*flow.Flow)(nil),                    // 21: flow.Flow
	(*relay.NodeStatusEvent)(nil),        // 22: relay.NodeStatusEvent
	(*flow.LostEvent)(nil),               // 23: flow.LostEvent
	(*flow.AgentEvent)(nil),              // 24: flow.AgentEvent
	(*flow.DebugEvent)(nil),              // 25: flow.DebugEvent
	(relay.NodeState)(0),                 // 26: relay.NodeState
	(*fieldmaskpb.FieldMask)(nil),        // 27: google.protobuf.FieldMask
}
var file_observer_observer_proto_depIdxs = []int32{
	17, // 0: observer.ServerStatusResponse.num_connected_nodes:type_name -> google.protobuf.UInt32Value
	17, // 1: observer.ServerStatusResponse.num_unavailable_nodes:type_name -> google.protobuf.UInt32Value
	18, // 2: observer.GetFlowsRequest.blacklist:type_name -> flow.FlowFilter
	18, // 3: observer.GetFlowsRequest.whitelist:type_name -> flow.FlowFilter
	19, // 4: observer.GetFlowsRequest.since:type_name -> google.protobuf.Timestamp
	19, // 5: observer.GetFlowsRequest.until:type_name -> google.protobuf.Timestamp
	16, // 6: observer.GetFlowsRequest.experimental:type_name -> observer.GetFlowsRequest.Experimental
	20, // 7: observer.GetFlowsRequest.extensions:type_name -> google.protobuf.Any
	21, // 8: observer.GetFlowsResponse.flow:type_name -> flow.Flow
	22, // 9: observer.GetFlowsResponse.node_status:type_name -> relay.NodeStatusEvent
	23, // 10: observer.GetFlowsResponse.lost_events:type_name -> flow.LostEvent
	19, // 11: observer.GetFlowsResponse.time:type_name -> google.protobuf.Timestamp
	19, // 12: observer.GetAgentEventsRequest.since:type_name -> google.protobuf.Timestamp
	19, // 13: observer.GetAgentEventsRequest.until:type_name -> google.protobuf.Timestamp
	24, // 14: observer.GetAgentEventsResponse.agent_event:type_name -> flow.AgentEvent
	19, // 15: observer.GetAgentEventsResponse.time:type_name -> google.protobuf.Timestamp
	19, // 16: observer.GetDebugEventsRequest.since:type_name -> google.protobuf.Timestamp
	19, // 17: observer.GetDebugEventsRequest.until:type_name -> google.protobuf.Timestamp
	25, // 18: observer.GetDebugEventsResponse.debug_event:type_name -> flow.DebugEvent
	19, // 19: observer.GetDebugEventsResponse.time:type_name -> google.protobuf.Timestamp
	10, // 20: observer.GetNodesResponse.nodes:type_name -> observer.Node
	26, // 21: observer.Node.state:type_name -> relay.NodeState
	11, // 22: observer.Node.tls:type_name -> observer.TLS
	14, // 23: observer.GetNamespacesResponse.namespaces:type_name -> observer.Namespace
	21, // 24: observer.ExportEvent.flow:type_name -> flow.Flow
	22, // 25: observer.ExportEvent.node_status:type_name -> relay.NodeStatusEvent
	23, // 26: observer.ExportEvent.lost_events:type_name -> flow.LostEvent
	24, // 27: observer.ExportEvent.agent_event:type_name -> flow.AgentEvent
	25, // 28: observer.ExportEvent.debug_event:type_name -> flow.DebugEvent
	19, // 29: observer.ExportEvent.time:type_name -> google.protobuf.Timestamp
	27, // 30: observer.GetFlowsRequest.Experimental.field_mask:type_name -> google.protobuf.FieldMask
	2,  // 31: observer.Observer.GetFlows:input_type -> observer.GetFlowsRequest
	4,  // 32: observer.Observer.GetAgentEvents:input_type -> observer.GetAgentEventsRequest
	6,  // 33: observer.Observer.GetDebugEvents:input_type -> observer.GetDebugEventsRequest
	8,  // 34: observer.Observer.GetNodes:input_type -> observer.GetNodesRequest
	12, // 35: observer.Observer.GetNamespaces:input_type -> observer.GetNamespacesRequest
	0,  // 36: observer.Observer.ServerStatus:input_type -> observer.ServerStatusRequest
	3,  // 37: observer.Observer.GetFlows:output_type -> observer.GetFlowsResponse
	5,  // 38: observer.Observer.GetAgentEvents:output_type -> observer.GetAgentEventsResponse
	7,  // 39: observer.Observer.GetDebugEvents:output_type -> observer.GetDebugEventsResponse
	9,  // 40: observer.Observer.GetNodes:output_type -> observer.GetNodesResponse
	13, // 41: observer.Observer.GetNamespaces:output_type -> observer.GetNamespacesResponse
	1,  // 42: observer.Observer.ServerStatus:output_type -> observer.ServerStatusResponse
	37, // [37:43] is the sub-list for method output_type
	31, // [31:37] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_observer_observer_proto_init() }
func file_observer_observer_proto_init() {
	if File_observer_observer_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_observer_observer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFlowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFlowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAgentEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAgentEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDebugEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDebugEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNamespacesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNamespacesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Namespace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_observer_observer_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFlowsRequest_Experimental); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_observer_observer_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*GetFlowsResponse_Flow)(nil),
		(*GetFlowsResponse_NodeStatus)(nil),
		(*GetFlowsResponse_LostEvents)(nil),
	}
	file_observer_observer_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*ExportEvent_Flow)(nil),
		(*ExportEvent_NodeStatus)(nil),
		(*ExportEvent_LostEvents)(nil),
		(*ExportEvent_AgentEvent)(nil),
		(*ExportEvent_DebugEvent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_observer_observer_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_observer_observer_proto_goTypes,
		DependencyIndexes: file_observer_observer_proto_depIdxs,
		MessageInfos:      file_observer_observer_proto_msgTypes,
	}.Build()
	File_observer_observer_proto = out.File
	file_observer_observer_proto_rawDesc = nil
	file_observer_observer_proto_goTypes = nil
	file_observer_observer_proto_depIdxs = nil
}
