// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/trace/v3/lightstep.proto

package tracev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on LightstepConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *LightstepConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LightstepConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// LightstepConfigMultiError, or nil if none found.
func (m *LightstepConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *LightstepConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetCollectorCluster()) < 1 {
		err := LightstepConfigValidationError{
			field:  "CollectorCluster",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for AccessTokenFile

	if all {
		switch v := interface{}(m.GetAccessToken()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LightstepConfigValidationError{
					field:  "AccessToken",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LightstepConfigValidationError{
					field:  "AccessToken",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessToken()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LightstepConfigValidationError{
				field:  "AccessToken",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetPropagationModes() {
		_, _ = idx, item

		if _, ok := LightstepConfig_PropagationMode_name[int32(item)]; !ok {
			err := LightstepConfigValidationError{
				field:  fmt.Sprintf("PropagationModes[%v]", idx),
				reason: "value must be one of the defined enum values",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return LightstepConfigMultiError(errors)
	}
	return nil
}

// LightstepConfigMultiError is an error wrapping multiple validation errors
// returned by LightstepConfig.ValidateAll() if the designated constraints
// aren't met.
type LightstepConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LightstepConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LightstepConfigMultiError) AllErrors() []error { return m }

// LightstepConfigValidationError is the validation error returned by
// LightstepConfig.Validate if the designated constraints aren't met.
type LightstepConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LightstepConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LightstepConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LightstepConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LightstepConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LightstepConfigValidationError) ErrorName() string { return "LightstepConfigValidationError" }

// Error satisfies the builtin error interface
func (e LightstepConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLightstepConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LightstepConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LightstepConfigValidationError{}
