// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2021 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ProxyStatus Status of proxy
//
// +k8s:deepcopy-gen=true
//
// swagger:model ProxyStatus
type ProxyStatus struct {

	// IP address that the proxy listens on
	IP string `json:"ip,omitempty"`

	// Port range used for proxying
	PortRange string `json:"port-range,omitempty"`

	// Detailed description of configured redirects
	Redirects []*ProxyRedirect `json:"redirects"`

	// Total number of listening proxy ports
	TotalPorts int64 `json:"total-ports,omitempty"`

	// Total number of ports configured to redirect to proxies
	TotalRedirects int64 `json:"total-redirects,omitempty"`
}

// Validate validates this proxy status
func (m *ProxyStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRedirects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ProxyStatus) validateRedirects(formats strfmt.Registry) error {

	if swag.IsZero(m.Redirects) { // not required
		return nil
	}

	for i := 0; i < len(m.Redirects); i++ {
		if swag.IsZero(m.Redirects[i]) { // not required
			continue
		}

		if m.Redirects[i] != nil {
			if err := m.Redirects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("redirects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ProxyStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ProxyStatus) UnmarshalBinary(b []byte) error {
	var res ProxyStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
