/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.xbean.asm9.AnnotationVisitor;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;
import org.apache.xbean.asm9.Type;

public class ClassAnnotationMetaDataFilter
implements MetaDataFilter {
    private final Set<String> _annos = new HashSet<String>();
    private static final Localizer _loc = Localizer.forPackage(ClassAnnotationMetaDataFilter.class);
    private Log _log = null;

    public ClassAnnotationMetaDataFilter(Class<?> anno) {
        this(new Class[]{anno});
    }

    public ClassAnnotationMetaDataFilter(Class<?>[] annos) {
        for (Class<?> anno : annos) {
            this._annos.add(Type.getDescriptor(anno));
        }
    }

    @Override
    public boolean matches(MetaDataFilter.Resource rsrc) throws IOException {
        if (this._annos.isEmpty() || !rsrc.getName().endsWith(".class")) {
            return false;
        }
        ClassReader cr = new ClassReader(rsrc.getContent());
        MatchAnnotationScanner classVisitor = new MatchAnnotationScanner(589824);
        cr.accept((ClassVisitor)classVisitor, 7);
        return classVisitor.matches;
    }

    public Log getLog() {
        return this._log;
    }

    public void setLog(Log _log) {
        this._log = _log;
    }

    public class MatchAnnotationScanner
    extends ClassVisitor {
        boolean matches;

        public MatchAnnotationScanner(int api) {
            super(api);
            this.matches = false;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (visible && ClassAnnotationMetaDataFilter.this._annos.contains(descriptor)) {
                this.matches = true;
            }
            return super.visitAnnotation(descriptor, visible);
        }
    }
}

