/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.ReferentialIntegrityException;

public class HSQLDictionary
extends DBDictionary {
    public boolean cacheTables = false;
    private int dbMajorVersion;
    private int dbMinorVersion;
    private int violation_of_unique_index_or_constraint;
    private SQLBuffer _oneBuffer = new SQLBuffer(this).append("1");

    public HSQLDictionary() {
        this.platform = "HSQL";
        this.validationSQL = "CALL 1";
        this.concatenateFunction = "CONCAT({0},{1})";
        this.closePoolSQL = "SHUTDOWN";
        this.supportsAutoAssign = true;
        this.lastGeneratedKeyQuery = "CALL IDENTITY()";
        this.autoAssignClause = "IDENTITY";
        this.autoAssignTypeName = "INTEGER";
        this.nextSequenceQuery = "SELECT NEXT VALUE FOR {0} FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES";
        this.crossJoinClause = "JOIN";
        this.requiresConditionForCrossJoin = true;
        this.stringLengthFunction = "LENGTH({0})";
        this.trimLeadingFunction = "LTRIM({0})";
        this.trimTrailingFunction = "RTRIM({0})";
        this.trimBothFunction = "LTRIM(RTRIM({0}))";
        this.supportsSelectForUpdate = false;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.supportsDeferredConstraints = false;
        this.supportsNullTableForGetPrimaryKeys = false;
        this.supportsNullTableForGetIndexInfo = false;
        this.requiresCastForMathFunctions = true;
        this.requiresCastForComparisons = true;
        this.reservedWordSet.addAll(Arrays.asList("BEFORE", "BIGINT", "BINARY", "CACHED", "DATETIME", "LIMIT", "LONGVARBINARY", "LONGVARCHAR", "OBJECT", "OTHER", "SAVEPOINT", "TEMP", "TEXT", "TRIGGER", "TINYINT", "VARBINARY", "VARCHAR_IGNORECASE"));
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("TEXT"));
        this.fixedSizeTypeNameSet.remove("NUMERIC");
        this.fixedSizeTypeNameSet.remove("DECIMAL");
        this.invalidColumnWordSet.addAll(Arrays.asList("ALL", "AND", "ANY", "AS", "AT", "BETWEEN", "BOTH", "BY", "CALL", "CASE", "CAST", "CHECK", "COALESCE", "CONSTRAINT", "CONVERT", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "DEFAULT", "DISTINCT", "DO", "DROP", "ELSE", "END-EXEC", "EVERY", "EXCEPT", "EXISTS", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GRANT", "GROUP", "GROUPING", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "NATURAL", "NOT", "NULLIF", "ON", "OR", "ORDER", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "ROLLUP", "SELECT", "SET", "SOME", "SUM", "TABLE", "THEN", "TO", "TRAILING", "TRIGGER", "UNION", "UNIQUE", "USING", "VALUES", "WHEN", "WHERE", "WITH"));
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        String fieldName;
        String packageName;
        super.connectedConfiguration(conn);
        this.determineHSQLDBVersion(conn);
        if (this.dbMajorVersion == 1) {
            this.blobTypeName = "VARBINARY";
            this.useGetObjectForBlobs = true;
            this.rangePosition = 1;
            this.useSchemaName = false;
        }
        if (this.dbMajorVersion > 1 && this.dbMinorVersion > 0) {
            this.nextSequenceQuery = this.nextSequenceQuery + " LIMIT 1";
        }
        if (this.dbMajorVersion > 1) {
            this.violation_of_unique_index_or_constraint = 104;
            packageName = "org.hsqldb.error.ErrorCode";
            fieldName = "X_23505";
        } else {
            this.violation_of_unique_index_or_constraint = 9;
            packageName = "org.hsqldb.Trace";
            fieldName = "VIOLATION_OF_UNIQUE_INDEX";
        }
        if (this.dbMajorVersion > 2 || this.dbMajorVersion == 2 && this.dbMinorVersion >= 4) {
            this.supportsUuidType = true;
        }
        try {
            Class<?> cls = Class.forName(packageName);
            Field fld = cls.getField(fieldName);
            this.violation_of_unique_index_or_constraint = fld.getInt(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void determineHSQLDBVersion(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        if (this.isJDBC3) {
            this.dbMajorVersion = metaData.getDatabaseMajorVersion();
            this.dbMinorVersion = metaData.getDatabaseMinorVersion();
        } else {
            String productVersion = metaData.getDatabaseProductVersion();
            String[] version = productVersion.split("\\.");
            this.dbMajorVersion = Integer.parseInt(version[0]);
            this.dbMinorVersion = Integer.parseInt(version[1]);
        }
    }

    @Override
    public int getPreferredType(int type) {
        if (this.dbMajorVersion > 1) {
            return super.getPreferredType(type);
        }
        switch (type) {
            case 2005: {
                return 12;
            }
            case 2004: {
                return -3;
            }
        }
        return super.getPreferredType(type);
    }

    @Override
    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        return new String[0];
    }

    @Override
    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        return new String[0];
    }

    @Override
    public String[] getAddColumnSQL(Column column) {
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " ADD COLUMN " + this.getDeclareColumnSQL(column, true)};
    }

    @Override
    public String[] getCreateTableSQL(Table table) {
        Unique[] unqs;
        String pkStr;
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE ");
        if (this.cacheTables) {
            buf.append("CACHED ");
        }
        buf.append("TABLE ").append(this.getFullName(table, false)).append(" (");
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getDeclareColumnSQL(cols[i], false));
        }
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && !StringUtil.isEmpty(pkStr = this.getPrimaryKeyConstraintSQL(pk))) {
            buf.append(", ").append(pkStr);
        }
        for (Unique unq : unqs = table.getUniques()) {
            String unqStr = this.getUniqueConstraintSQL(unq);
            if (unqStr == null) continue;
            buf.append(", ").append(unqStr);
        }
        buf.append(")");
        return new String[]{buf.toString()};
    }

    @Override
    protected String getPrimaryKeyConstraintSQL(PrimaryKey pk) {
        Column[] cols = pk.getColumns();
        if (cols.length == 1 && cols[0].isAutoAssigned()) {
            return null;
        }
        return super.getPrimaryKeyConstraintSQL(pk);
    }

    @Override
    public boolean isSystemIndex(String name, Table table) {
        return name.toUpperCase(Locale.ENGLISH).startsWith("SYS_");
    }

    @Override
    public boolean isSystemIndex(DBIdentifier name, Table table) {
        if (DBIdentifier.isNull(name)) {
            return false;
        }
        return name.getName().toUpperCase(Locale.ENGLISH).startsWith("SYS_");
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT SEQUENCE_SCHEMA, SEQUENCE_NAME FROM ").append("INFORMATION_SCHEMA.SYSTEM_SEQUENCES");
        if (!DBIdentifier.isNull(schemaName) || !DBIdentifier.isNull(sequenceName)) {
            buf.append(" WHERE ");
        }
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append("SEQUENCE_SCHEMA = ?");
            if (!DBIdentifier.isNull(sequenceName)) {
                buf.append(" AND ");
            }
        }
        if (!DBIdentifier.isNull(sequenceName)) {
            buf.append("SEQUENCE_NAME = ?");
        }
        return buf.toString();
    }

    @Override
    public SQLBuffer toOperation(String op, SQLBuffer selects, SQLBuffer from, SQLBuffer where, SQLBuffer group, SQLBuffer having, SQLBuffer order, boolean distinct, long start, long end, String forUpdateClause) {
        if (!(start == 0L && end == Long.MAX_VALUE || order != null && !order.isEmpty())) {
            order = this._oneBuffer;
        }
        return super.toOperation(op, selects, from, where, group, having, order, distinct, start, end, forUpdateClause);
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            if (!"BOOLEAN".equalsIgnoreCase(cols[i].getTypeIdentifier().getName())) continue;
            cols[i].setType(-7);
        }
        return cols;
    }

    @Override
    public void setDouble(PreparedStatement stmnt, int idx, double val, Column col) throws SQLException {
        if (val == 9.223372036854776E18 || val == -9.223372036854776E18) {
            stmnt.setLong(idx, (long)val);
        } else {
            super.setDouble(stmnt, idx, val, col);
        }
    }

    @Override
    public void setBigDecimal(PreparedStatement stmnt, int idx, BigDecimal val, Column col) throws SQLException {
        int type = val == null || col == null ? 24 : col.getJavaType();
        switch (type) {
            case 3: 
            case 19: {
                this.setDouble(stmnt, idx, val.doubleValue(), col);
                break;
            }
            case 4: 
            case 20: {
                this.setDouble(stmnt, idx, val.floatValue(), col);
                break;
            }
            default: {
                super.setBigDecimal(stmnt, idx, val, col);
            }
        }
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (this.dbMajorVersion > 1) {
            if (start != 0L) {
                buf.append(" OFFSET ").appendValue(start);
            }
            if (end != Long.MAX_VALUE) {
                buf.append(" LIMIT ").appendValue(end - start);
            }
            return;
        }
        buf.append(" LIMIT ").append(String.valueOf(start)).append(" ");
        if (end == Long.MAX_VALUE) {
            buf.append(String.valueOf(0));
        } else {
            buf.append(String.valueOf(end - start));
        }
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("LOCATE(");
        find.appendTo(buf);
        buf.append(", ");
        str.appendTo(buf);
        if (start != null) {
            buf.append(", ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    @Override
    public String getPlaceholderValueString(Column col) {
        Object type = this.getTypeName(col.getType());
        int idx = ((String)type).indexOf("{0}");
        if (idx != -1) {
            String pre = ((String)type).substring(0, idx);
            type = ((String)type).length() > idx + 3 ? pre + ((String)type).substring(idx + 3) : pre;
        }
        return "NULL AS " + (String)type;
    }

    @Override
    public OpenJPAException newStoreException(String msg, SQLException[] causes, Object failed) {
        OpenJPAException ke = super.newStoreException(msg, causes, failed);
        if (ke instanceof ReferentialIntegrityException && causes[0].getErrorCode() == -this.violation_of_unique_index_or_constraint) {
            ((ReferentialIntegrityException)ke).setIntegrityViolation(2);
        }
        return ke;
    }
}

