/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.config;

import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;

public class BasicSecurityConfiguration
implements SecurityConfiguration,
IdentifiableComponent {
    @Nullable
    private String id;
    @Nonnull
    private final Duration clockSkew;
    @Nonnull
    private final IdentifierGenerationStrategy idGenerator;
    @Nullable
    private ClientTLSValidationConfiguration clientTLSConfig;
    @Nullable
    private HttpClientSecurityConfiguration httpClientConfig;

    public BasicSecurityConfiguration() {
        this.clockSkew = Duration.ofMinutes(5L);
        this.idGenerator = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE);
    }

    public BasicSecurityConfiguration(@Nonnull Duration skew, @Nonnull IdentifierGenerationStrategy generator) {
        Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
        Constraint.isFalse((skew.isNegative() || skew.isZero() ? 1 : 0) != 0, (String)"Clock skew must be greater than 0");
        this.clockSkew = skew;
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"Identifier generator cannot be null");
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String componentId) {
        this.id = componentId;
    }

    @Override
    @Nonnull
    public Duration getClockSkew() {
        return this.clockSkew;
    }

    @Override
    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    @Nullable
    public ClientTLSValidationConfiguration getClientTLSValidationConfiguration() {
        return this.clientTLSConfig;
    }

    @Nonnull
    public BasicSecurityConfiguration setClientTLSValidationConfiguration(@Nullable ClientTLSValidationConfiguration config) {
        this.clientTLSConfig = config;
        return this;
    }

    @Override
    @Nullable
    public HttpClientSecurityConfiguration getHttpClientSecurityConfiguration() {
        return this.httpClientConfig;
    }

    @Nonnull
    public BasicSecurityConfiguration setHttpClientSecurityConfiguration(@Nullable HttpClientSecurityConfiguration config) {
        this.httpClientConfig = config;
        return this;
    }
}

