/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

import io.churchkey.asn1.Asn1Class;
import io.churchkey.asn1.Asn1Construction;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.asn1.Oid;
import io.churchkey.asn1.Tag;
import io.churchkey.asn1.Utils;
import io.churchkey.util.Bytes;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;

public class Asn1Object {
    private final Tag tag;
    private final int length;
    private final byte[] value;

    public Asn1Object(byte tag, int len, byte ... data) {
        this(Tag.fromDer(tag), len, data);
    }

    public Asn1Object(Asn1Class c, Asn1Type t, boolean ctored, int len, byte ... data) {
        this(new Tag(c, ctored ? Asn1Construction.CONSTRUCTED : Asn1Construction.PRIMITIVE, t), len, data);
    }

    public Asn1Object(Tag tag, int len, byte ... data) {
        this.tag = tag;
        this.length = len;
        this.value = data;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Asn1Class getAsn1Class() {
        return this.tag.getClazz();
    }

    public Asn1Type getType() {
        return this.tag.getType();
    }

    public boolean isType(Asn1Type type) {
        return this.tag.getType().equals((Object)type);
    }

    public Asn1Object assertType(Asn1Type type) {
        if (!this.isType(type)) {
            throw new IllegalStateException(String.format("Expected type %s, found %s", new Object[]{type, this.tag.getType()}));
        }
        return this;
    }

    public boolean isConstructed() {
        return this.tag.getConstruction().equals((Object)Asn1Construction.CONSTRUCTED);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getPureValueBytes() {
        byte[] bytes = this.getValue();
        int available = this.getLength();
        int numBytes = Utils.length(bytes);
        if (numBytes == available) {
            return bytes;
        }
        if (available == 0) {
            return Utils.EMPTY_BYTE_ARRAY;
        }
        byte[] pure = new byte[available];
        System.arraycopy(bytes, 0, pure, 0, available);
        return pure;
    }

    public DerParser createParser() {
        return new DerParser(this.getValue(), 0, this.getLength());
    }

    public Object asObject() throws IOException {
        Asn1Type type = this.getType();
        if (type == null) {
            throw new IOException("No type set");
        }
        switch (type) {
            case INTEGER: {
                return this.asInteger();
            }
            case NUMERIC_STRING: 
            case PRINTABLE_STRING: 
            case VIDEOTEX_STRING: 
            case IA5_STRING: 
            case GRAPHIC_STRING: 
            case VISIBLE_STRING: 
            case GENERAL_STRING: 
            case BMP_STRING: 
            case UTF8_STRING: {
                return this.asString();
            }
            case OBJECT_IDENTIFIER: {
                return this.asOID();
            }
            case SEQUENCE: {
                return this.getValue();
            }
        }
        throw new IOException("Invalid DER: unsupported type: " + (Object)((Object)type));
    }

    public BigInteger asInteger() throws IOException {
        Asn1Type typeValue = this.getType();
        if (Asn1Type.INTEGER.equals((Object)typeValue)) {
            return this.toInteger();
        }
        throw new IOException("Invalid DER: object is not integer: " + (Object)((Object)typeValue));
    }

    public BigInteger toInteger() {
        if (this.isType(Asn1Type.OCTET_STRING)) {
            return new BigInteger(1, this.getPureValueBytes());
        }
        return new BigInteger(this.getPureValueBytes());
    }

    public String asString() throws IOException {
        String encoding;
        Asn1Type type = this.getType();
        if (type == null) {
            throw new IOException("No type set");
        }
        switch (type) {
            case NUMERIC_STRING: 
            case PRINTABLE_STRING: 
            case VIDEOTEX_STRING: 
            case IA5_STRING: 
            case GRAPHIC_STRING: 
            case VISIBLE_STRING: 
            case GENERAL_STRING: {
                encoding = "ISO-8859-1";
                break;
            }
            case BMP_STRING: {
                encoding = "UTF-16BE";
                break;
            }
            case UTF8_STRING: {
                encoding = "UTF-8";
                break;
            }
            case UNIVERSAL_STRING: {
                throw new IOException("Invalid DER: can't handle UCS-4 string");
            }
            default: {
                throw new IOException("Invalid DER: object is not a string: " + (Object)((Object)type));
            }
        }
        return new String(this.getValue(), 0, this.getLength(), encoding);
    }

    public Oid asOID() throws IOException {
        Asn1Type typeValue = this.getType();
        if (Asn1Type.OBJECT_IDENTIFIER.equals((Object)typeValue)) {
            return this.toOID();
        }
        throw new StreamCorruptedException("Invalid DER: object is not an OID: " + (Object)((Object)typeValue));
    }

    public Oid toOID() throws IOException {
        int vLen = this.getLength();
        if (vLen <= 0) {
            throw new EOFException("Not enough data for an OID");
        }
        ArrayList<Integer> oid = new ArrayList<Integer>(vLen + 1);
        byte[] bytes = this.getValue();
        int val1 = bytes[0] & 0xFF;
        oid.add(val1 / 40);
        oid.add(val1 % 40);
        for (int curPos = 1; curPos < vLen; ++curPos) {
            int v = bytes[curPos] & 0xFF;
            if (v <= 127) {
                oid.add(v);
                continue;
            }
            long curVal = v & 0x7F;
            ++curPos;
            int subLen = 1;
            while (true) {
                if (curPos >= vLen) {
                    throw new EOFException("Incomplete OID value");
                }
                if (subLen > 5) {
                    throw new StreamCorruptedException("OID component encoding beyond 5 bytes");
                }
                v = bytes[curPos] & 0xFF;
                if ((curVal = curVal << 7 & 0xFFFFFFFF80L | (long)v & 0x7FL) > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("OID value exceeds 32 bits: " + curVal);
                }
                if (v <= 127) break;
                ++subLen;
                ++curPos;
            }
            oid.add((int)(curVal & Integer.MAX_VALUE));
        }
        return new Oid(oid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getAsn1Class(), this.getType()}) + Boolean.hashCode(this.isConstructed()) + this.getLength() + Utils.hashCode(this.getValue(), 0, this.getLength());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Asn1Object other = (Asn1Object)obj;
        return Objects.equals((Object)this.getAsn1Class(), (Object)other.getAsn1Class()) && Objects.equals((Object)this.getType(), (Object)other.getType()) && this.isConstructed() == other.isConstructed() && this.getLength() == other.getLength() && Utils.diffOffset(this.getValue(), 0, other.getValue(), 0, this.getLength()) < 0;
    }

    public static Asn1Object sequence(byte[] bytes) {
        return new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.SEQUENCE, true, bytes.length, bytes);
    }

    public static Asn1Object octetString(byte[] bytes) {
        if ((bytes = Bytes.trim(bytes)).length == 0) {
            bytes = new byte[]{0};
        }
        return new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.OCTET_STRING, false, bytes.length, bytes);
    }

    public static Asn1Object bitString(byte[] bytes) {
        return new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.BIT_STRING, false, bytes.length, bytes);
    }

    public static Asn1Object nill() {
        return new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.NULL, false, 0, new byte[0]);
    }

    public static Asn1Object objectIdentifier(Oid oid) {
        byte[] bytes = oid.toBytes();
        return new Asn1Object(Asn1Class.UNIVERSAL, Asn1Type.OBJECT_IDENTIFIER, false, bytes.length, bytes);
    }

    public String toString() {
        return Objects.toString((Object)this.getAsn1Class()) + "/" + (Object)((Object)this.getType()) + "/" + this.isConstructed() + "[" + this.getLength() + "]: " + Utils.toHex(this.getValue(), 0, this.getLength(), ':');
    }
}

