/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.objectweb.howl.log.ConfigurationMBean;
import org.objectweb.howl.log.LogConfigurationException;

public class Configuration
implements ConfigurationMBean {
    private static final int MAX_BUFFER_SIZE = 32;
    private Properties prop = null;
    private boolean listConfig = false;
    private boolean adler32Checksum = false;
    private boolean checksumEnabled = false;
    private int bufferSize = 4096;
    private String bufferClassName = "org.objectweb.howl.log.BlockLogBuffer";
    private int maxBuffers = 0;
    private int minBuffers = 4;
    private int flushSleepTime = 50;
    private boolean flushPartialBuffers = false;
    private int threadsWaitingForceThreshold = Integer.MAX_VALUE;
    private int maxBlocksPerFile = Integer.MAX_VALUE;
    private int maxLogFiles = 2;
    private String logFileDir = "../logs";
    private String logFileExt = "log";
    private String logFileName = "logger";
    private String logFileMode = "rw";

    public Configuration() {
        this.prop = new Properties();
        try {
            this.parseProperties();
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    public Configuration(Properties prop) throws LogConfigurationException {
        this.prop = new Properties(prop);
        this.parseProperties();
    }

    public Configuration(File propertyFile) throws LogConfigurationException {
        this();
        try {
            this.prop.load(new FileInputStream(propertyFile));
            this.parseProperties();
        }
        catch (FileNotFoundException e) {
            LogConfigurationException lce = new LogConfigurationException(e.toString(), e);
            throw lce;
        }
        catch (IOException e) {
            throw new LogConfigurationException(e.toString(), e);
        }
    }

    private void showConfig(String key, int val, String text) {
        if (this.listConfig) {
            System.err.println(key + ": " + val + " " + text);
        }
    }

    private int getInteger(String key, int val, String text) {
        val = Integer.parseInt(this.prop.getProperty(key, Integer.toString(val)).trim());
        this.showConfig(key, val, text);
        this.prop.setProperty(key, Integer.toString(val));
        return val;
    }

    private int getInteger(String key, int val) {
        return this.getInteger(key, val, "");
    }

    private boolean getBoolean(String key, boolean val) throws LogConfigurationException {
        String pval = this.prop.getProperty(key, Boolean.toString(val)).toLowerCase().trim();
        if (!pval.equals("true") && !pval.equals("false")) {
            throw new LogConfigurationException(key + "[" + pval + "] must be true of false");
        }
        val = Boolean.valueOf(pval);
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
        this.prop.setProperty(key, Boolean.toString(val));
        return val;
    }

    private String getString(String key, String val) {
        val = this.prop.getProperty(key, val).trim();
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
        this.prop.setProperty(key, val);
        return val;
    }

    private void parseProperties() throws LogConfigurationException {
        this.listConfig = this.getBoolean("listConfig", this.listConfig);
        this.bufferClassName = this.getString("bufferClassName", this.bufferClassName);
        this.setBufferSize(this.getInteger("bufferSize", this.bufferSize / 1024, "Kb"));
        this.adler32Checksum = this.getBoolean("adler32Checksum", this.adler32Checksum);
        this.checksumEnabled = this.getBoolean("checksumEnabled", this.checksumEnabled);
        this.flushPartialBuffers = this.getBoolean("flushPartialBuffers", this.flushPartialBuffers);
        this.flushSleepTime = this.getInteger("flushSleepTime", this.flushSleepTime);
        this.logFileDir = this.getString("logFileDir", this.logFileDir);
        this.logFileExt = this.getString("logFileExt", this.logFileExt);
        this.setLogFileMode(this.getString("logFileMode", this.logFileMode));
        this.logFileName = this.getString("logFileName", this.logFileName);
        this.maxBlocksPerFile = this.getInteger("maxBlocksPerFile", this.maxBlocksPerFile);
        this.setMinBuffers(this.getInteger("minBuffers", this.minBuffers));
        this.setMaxBuffers(this.getInteger("maxBuffers", this.maxBuffers));
        this.maxLogFiles = this.getInteger("maxLogFiles", this.maxLogFiles);
        this.threadsWaitingForceThreshold = this.getInteger("threadsWaitingForceThreshold", this.threadsWaitingForceThreshold);
    }

    public String getLogFileDir() {
        return this.logFileDir;
    }

    public void setLogFileDir(String logFileDir) {
        this.logFileDir = logFileDir;
        this.prop.setProperty("logFiledir", logFileDir);
    }

    public String getLogFileExt() {
        return this.logFileExt;
    }

    public void setLogFileExt(String logFileExt) {
        this.logFileExt = logFileExt;
        this.prop.setProperty("logFileExt", logFileExt);
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        this.prop.setProperty("logFileName", logFileName);
    }

    public boolean isAdler32ChecksumEnabled() {
        return this.adler32Checksum;
    }

    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumOption) {
        this.checksumEnabled = checksumOption;
        this.prop.setProperty("checksumEnabled", Boolean.toString(this.checksumEnabled));
    }

    public int getBufferSize() {
        return this.bufferSize / 1024;
    }

    public void setBufferSize(int bufferSize) throws LogConfigurationException {
        if (bufferSize < 1 || bufferSize > 32) {
            throw new LogConfigurationException("bufferSize [" + bufferSize + "] must be" + " between 1 and " + 32);
        }
        this.bufferSize = bufferSize * 1024;
        this.prop.setProperty("bufferSize", Integer.toString(bufferSize));
    }

    public String getBufferClassName() {
        return this.bufferClassName;
    }

    public void setAdler32Checksum(boolean adler32Checksum) {
        this.adler32Checksum = adler32Checksum;
    }

    public void setBufferClassName(String bufferClassName) {
        this.bufferClassName = bufferClassName;
        this.prop.setProperty("bufferClassName", bufferClassName);
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public void setMaxBuffers(int maxBuffers) throws LogConfigurationException {
        if (maxBuffers > 0 && maxBuffers < this.minBuffers) {
            throw new LogConfigurationException("minBuffers [" + this.minBuffers + "] must be <= than maxBuffers[" + maxBuffers + "]");
        }
        this.maxBuffers = maxBuffers;
        this.prop.setProperty("maxBuffers", Integer.toString(maxBuffers));
    }

    public int getMinBuffers() {
        return this.minBuffers;
    }

    public void setMinBuffers(int minBuffers) throws LogConfigurationException {
        if (minBuffers <= 0) {
            throw new LogConfigurationException("minBuffers[" + minBuffers + "] must be > 0");
        }
        this.minBuffers = minBuffers;
        this.prop.setProperty("minBuffers", Integer.toString(minBuffers));
    }

    public int getFlushSleepTime() {
        return this.flushSleepTime;
    }

    public void setFlushSleepTime(int flushSleepTime) {
        this.flushSleepTime = flushSleepTime;
        this.prop.setProperty("flushSleepTime", Integer.toString(flushSleepTime));
    }

    public int getThreadsWaitingForceThreshold() {
        return this.threadsWaitingForceThreshold;
    }

    public void setThreadsWaitingForceThreshold(int threadsWaitingForceThreshold) {
        this.threadsWaitingForceThreshold = threadsWaitingForceThreshold;
        this.prop.setProperty("threadsWaitingForceThreshold", Integer.toString(threadsWaitingForceThreshold));
    }

    public int getMaxBlocksPerFile() {
        return this.maxBlocksPerFile;
    }

    public void setMaxBlocksPerFile(int maxBlocksPerFile) {
        this.maxBlocksPerFile = maxBlocksPerFile;
        this.prop.setProperty("maxBlocksPerFile", Integer.toString(maxBlocksPerFile));
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.maxLogFiles = maxLogFiles;
        this.prop.setProperty("maxLogFiles", Integer.toString(maxLogFiles));
    }

    public String getLogFileMode() {
        return this.logFileMode;
    }

    public void setLogFileMode(String logFileMode) throws LogConfigurationException {
        if (!logFileMode.equals("rw") && !logFileMode.equals("rwd")) {
            throw new LogConfigurationException("logFileMode[" + logFileMode + "] must be \"rw\" or \"rwd\"");
        }
        this.logFileMode = logFileMode;
        this.prop.setProperty("logFileMode", logFileMode);
    }

    public void store(OutputStream out) throws IOException {
        String header = "HOWL Configuration properties\n#Generated by " + this.getClass().getName();
        try {
            this.prop.store(out, header);
        }
        catch (IOException e) {
            IOException ioe = new IOException("Configuration.store(): error writing properties.[" + e.getMessage() + "]");
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    public boolean isFlushPartialBuffers() {
        return this.flushPartialBuffers;
    }

    public void setFlushPartialBuffers(boolean flushPartialBuffers) {
        this.flushPartialBuffers = flushPartialBuffers;
        this.prop.setProperty("flushPartialBuffers", Boolean.toString(flushPartialBuffers));
    }
}

