/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.Asserts;

public class ExtensionBeanBuilder<T extends Extension> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final T extension;

    public ExtensionBeanBuilder(WebBeansContext webBeansContext, T extension) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(extension, "extension");
        this.webBeansContext = webBeansContext;
        this.annotatedType = webBeansContext.getAnnotatedElementFactory().newAnnotatedType(extension.getClass());
        this.extension = extension;
    }

    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    public T getExtension() {
        return this.extension;
    }

    public ExtensionBean<T> buildBean() {
        return new ExtensionBean(this.webBeansContext, this.annotatedType.getJavaClass());
    }
}

