/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.responses;

import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.headers.HeaderIO;
import io.smallrye.openapi.runtime.io.links.LinkIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class APIResponseIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<APIResponse, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_RESPONSE_CODE = "responseCode";
    private static final String PROP_HEADERS = "headers";
    private static final String PROP_LINKS = "links";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_RESPONSE_DESCRIPTION = "responseDescription";
    private static final String PROP_VALUE = "value";
    private final LinkIO<V, A, O, AB, OB> linkIO;
    private final HeaderIO<V, A, O, AB, OB> headerIO;
    private final ContentIO<V, A, O, AB, OB> contentIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public APIResponseIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.API_RESPONSE, DotName.createSimple(APIResponse.class));
        this.linkIO = new LinkIO<V, A, O, AB, OB>(context, extensionIO);
        this.contentIO = contentIO;
        this.headerIO = new HeaderIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.extensionIO = extensionIO;
    }

    @Override
    public APIResponse read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@APIResponse");
        APIResponseImpl response = new APIResponseImpl();
        response.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        response.setHeaders(this.headerIO.readMap(annotation.value(PROP_HEADERS)));
        response.setLinks(this.linkIO.readMap(annotation.value(PROP_LINKS)));
        response.setContent(this.contentIO.read(annotation.value(PROP_CONTENT), ContentIO.Direction.OUTPUT));
        response.setExtensions(this.extensionIO.readExtensible(annotation));
        response.setRef(ReferenceType.RESPONSE.refValue(annotation));
        response.setResponseCode(this.responseCode(annotation).orElse(null));
        return response;
    }

    Map<String, APIResponse> readResponseSchema(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@APIResponseSchema");
        String responseCode = (String)this.value(annotation, PROP_RESPONSE_CODE);
        APIResponseImpl response = new APIResponseImpl();
        response.setDescription((String)this.value(annotation, PROP_RESPONSE_DESCRIPTION));
        response.setResponseCode(responseCode);
        Optional.ofNullable(this.scannerContext().getCurrentProduces()).ifPresent(mediaTypes -> {
            Type responseType = (Type)this.value(annotation, PROP_VALUE);
            if (!TypeUtil.isVoid(responseType)) {
                ContentImpl content = new ContentImpl();
                Schema responseSchema = SchemaFactory.typeToSchema(this.scannerContext(), responseType, null, this.scannerContext().getExtensions());
                for (String mediaType : mediaTypes) {
                    content.addMediaType(mediaType, new MediaTypeImpl().schema(responseSchema));
                }
                response.setContent(content);
            }
        });
        return Collections.singletonMap(responseCode, response);
    }

    public Optional<String> responseCode(AnnotationInstance annotation) {
        String responseCode = (String)this.value(annotation, PROP_RESPONSE_CODE);
        String ref = ReferenceType.RESPONSE.refValue(annotation);
        if (responseCode != null) {
            return Optional.of(responseCode);
        }
        if (ref != null) {
            return Optional.ofNullable(ModelUtil.getComponent(this.scannerContext().getOpenApi(), ref)).filter(APIResponseImpl.class::isInstance).map(APIResponseImpl.class::cast).map(APIResponseImpl::getResponseCode);
        }
        return Optional.of("default");
    }

    @Override
    public APIResponse readObject(O node) {
        IoLogging.logger.singleJsonObject("Response");
        APIResponseImpl model = new APIResponseImpl();
        model.setRef(this.readReference(node));
        model.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        model.setHeaders(this.headerIO.readMap(this.jsonIO().getValue(node, PROP_HEADERS)));
        model.setContent((Content)this.contentIO.readValue(this.jsonIO().getValue(node, PROP_CONTENT)));
        model.setLinks(this.linkIO.readMap(this.jsonIO().getValue(node, PROP_LINKS)));
        model.setExtensions(this.extensionIO.readMap(node));
        return model;
    }

    @Override
    public Optional<O> write(APIResponse model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
            } else {
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_HEADERS, this.headerIO.write(model.getHeaders()));
                this.setIfPresent(node, PROP_CONTENT, this.contentIO.write(model.getContent()));
                this.setIfPresent(node, PROP_LINKS, this.linkIO.write(model.getLinks()));
                this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

