/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.validation;

import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public abstract class AbstractBindingResultAssert<SELF extends AbstractBindingResultAssert<SELF>>
extends AbstractAssert<SELF, BindingResult> {
    private final Failures failures = Failures.instance();
    private final String name;

    protected AbstractBindingResultAssert(String name, BindingResult bindingResult, Class<?> selfType) {
        super((Object)bindingResult, selfType);
        this.name = name;
        this.as("Binding result for attribute '%s", new Object[]{this.name});
    }

    public SELF hasErrorsCount(int expected) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)((BindingResult)this.actual).getErrorCount()).as("check errors for attribute '%s'", new Object[]{this.name})).isEqualTo(expected);
        return (SELF)((Object)((AbstractBindingResultAssert)this.myself));
    }

    public SELF hasFieldErrors(String ... fieldNames) {
        ((ListAssert)Assertions.assertThat(this.fieldErrorNames())).contains((Object[])fieldNames);
        return (SELF)((Object)((AbstractBindingResultAssert)this.myself));
    }

    public SELF hasOnlyFieldErrors(String ... fieldNames) {
        ((ListAssert)Assertions.assertThat(this.fieldErrorNames())).containsOnly((Object[])fieldNames);
        return (SELF)((Object)((AbstractBindingResultAssert)this.myself));
    }

    public SELF hasFieldErrorCode(String fieldName, String errorCode) {
        ((AbstractStringAssert)Assertions.assertThat((String)this.getFieldError(fieldName).getCode()).as("check error code for field '%s'", new Object[]{fieldName})).isEqualTo(errorCode);
        return (SELF)((Object)((AbstractBindingResultAssert)this.myself));
    }

    protected AssertionError unexpectedBindingResult(String reason, Object ... arguments) {
        return this.failures.failure((AssertionInfo)this.info, (ErrorMessageFactory)new UnexpectedBindingResult(reason, arguments));
    }

    private AssertProvider<ListAssert<String>> fieldErrorNames() {
        return () -> {
            List<String> actual = ((BindingResult)this.actual).getFieldErrors().stream().map(FieldError::getField).toList();
            return (ListAssert)new ListAssert(actual).as("check field errors", new Object[0]);
        };
    }

    private FieldError getFieldError(String fieldName) {
        FieldError fieldError = ((BindingResult)this.actual).getFieldError(fieldName);
        if (fieldError == null) {
            throw this.unexpectedBindingResult("to have at least an error for field '%s'", fieldName);
        }
        return fieldError;
    }

    private final class UnexpectedBindingResult
    extends BasicErrorMessageFactory {
        private UnexpectedBindingResult(String reason, Object ... arguments) {
            super("%nExpecting binding result:%n  %s%n%s", new Object[]{AbstractBindingResultAssert.this.actual, reason.formatted(arguments)});
        }
    }
}

