/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.semaphore;

import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;

public interface AsyncSemaphore {
    public CompletableFuture<AsyncSemaphorePermit> acquire(long var1, BooleanSupplier var3);

    public CompletableFuture<AsyncSemaphorePermit> update(AsyncSemaphorePermit var1, long var2, BooleanSupplier var4);

    public void release(AsyncSemaphorePermit var1);

    public long getAvailablePermits();

    public long getAcquiredPermits();

    public int getQueueSize();

    public static interface AsyncSemaphorePermit {
        public long getPermits();
    }

    public static class PermitAcquireCancelledException
    extends PermitAcquireException {
        public PermitAcquireCancelledException(String message) {
            super(message);
        }
    }

    public static class PermitAcquireAlreadyClosedException
    extends PermitAcquireException {
        public PermitAcquireAlreadyClosedException(String message) {
            super(message);
        }
    }

    public static class PermitAcquireQueueFullException
    extends PermitAcquireException {
        public PermitAcquireQueueFullException(String message) {
            super(message);
        }
    }

    public static class PermitAcquireTimeoutException
    extends PermitAcquireException {
        public PermitAcquireTimeoutException(String message) {
            super(message);
        }
    }

    public static abstract class PermitAcquireException
    extends RuntimeException {
        public PermitAcquireException(String message) {
            super(message);
        }
    }
}

