/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.longlong;

public class LongUtils {
    public static final long MAX_UNSIGNED_INT = Integer.toUnsignedLong(-1);

    public static byte[] highPart(long num) {
        return new byte[]{(byte)(num >>> 56 & 0xFFL), (byte)(num >>> 48 & 0xFFL), (byte)(num >>> 40 & 0xFFL), (byte)(num >>> 32 & 0xFFL), (byte)(num >>> 24 & 0xFFL), (byte)(num >>> 16 & 0xFFL)};
    }

    public static char lowPart(long num) {
        return (char)num;
    }

    public static long toLong(byte[] high, char low) {
        return LongUtils.toLong(high) << 16 | (long)low;
    }

    public static long toLong(byte[] high) {
        return ((long)high[0] & 0xFFL) << 40 | ((long)high[1] & 0xFFL) << 32 | ((long)high[2] & 0xFFL) << 24 | ((long)high[3] & 0xFFL) << 16 | ((long)high[4] & 0xFFL) << 8 | (long)high[5] & 0xFFL;
    }

    public static long toLong(long high, char low) {
        return high << 16 | (long)low;
    }

    public static byte[] toBDBytes(long v) {
        byte[] work = new byte[8];
        work[7] = (byte)v;
        work[6] = (byte)(v >> 8);
        work[5] = (byte)(v >> 16);
        work[4] = (byte)(v >> 24);
        work[3] = (byte)(v >> 32);
        work[2] = (byte)(v >> 40);
        work[1] = (byte)(v >> 48);
        work[0] = (byte)(v >> 56);
        return work;
    }

    public static long fromBDBytes(byte[] work) {
        return (long)work[0] << 56 | (long)(work[1] & 0xFF) << 48 | (long)(work[2] & 0xFF) << 40 | (long)(work[3] & 0xFF) << 32 | (long)(work[4] & 0xFF) << 24 | (long)(work[5] & 0xFF) << 16 | (long)(work[6] & 0xFF) << 8 | (long)(work[7] & 0xFF);
    }

    public static long initWithFirst4Byte(int v) {
        return (long)v << 32;
    }

    public static long rightShiftHighPart(long num) {
        return num >>> 16;
    }

    public static long leftShiftHighPart(long num) {
        return num << 16;
    }

    public static int maxLowBitAsInteger() {
        return 65535;
    }

    public static byte[] highPartInPlace(long num, byte[] high48) {
        high48[0] = (byte)(num >>> 56 & 0xFFL);
        high48[1] = (byte)(num >>> 48 & 0xFFL);
        high48[2] = (byte)(num >>> 40 & 0xFFL);
        high48[3] = (byte)(num >>> 32 & 0xFFL);
        high48[4] = (byte)(num >>> 24 & 0xFFL);
        high48[5] = (byte)(num >>> 16 & 0xFFL);
        return high48;
    }

    public static boolean isMaxHigh(long key) {
        return (key & 0xFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFL;
    }
}

