/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLightingTransitionTagged is the corresponding interface of BACnetLightingTransitionTagged
type BACnetLightingTransitionTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetLightingTransition
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetLightingTransitionTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLightingTransitionTagged()
	// CreateBuilder creates a BACnetLightingTransitionTaggedBuilder
	CreateBACnetLightingTransitionTaggedBuilder() BACnetLightingTransitionTaggedBuilder
}

// _BACnetLightingTransitionTagged is the data-structure of this message
type _BACnetLightingTransitionTagged struct {
	Header           BACnetTagHeader
	Value            BACnetLightingTransition
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLightingTransitionTagged = (*_BACnetLightingTransitionTagged)(nil)

// NewBACnetLightingTransitionTagged factory function for _BACnetLightingTransitionTagged
func NewBACnetLightingTransitionTagged(header BACnetTagHeader, value BACnetLightingTransition, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetLightingTransitionTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLightingTransitionTagged must not be nil")
	}
	return &_BACnetLightingTransitionTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLightingTransitionTaggedBuilder is a builder for BACnetLightingTransitionTagged
type BACnetLightingTransitionTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetLightingTransition, proprietaryValue uint32) BACnetLightingTransitionTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLightingTransitionTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLightingTransitionTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetLightingTransition) BACnetLightingTransitionTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetLightingTransitionTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLightingTransitionTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLightingTransitionTaggedBuilder
	// Build builds the BACnetLightingTransitionTagged or returns an error if something is wrong
	Build() (BACnetLightingTransitionTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLightingTransitionTagged
}

// NewBACnetLightingTransitionTaggedBuilder() creates a BACnetLightingTransitionTaggedBuilder
func NewBACnetLightingTransitionTaggedBuilder() BACnetLightingTransitionTaggedBuilder {
	return &_BACnetLightingTransitionTaggedBuilder{_BACnetLightingTransitionTagged: new(_BACnetLightingTransitionTagged)}
}

type _BACnetLightingTransitionTaggedBuilder struct {
	*_BACnetLightingTransitionTagged

	collectedErr []error
}

var _ (BACnetLightingTransitionTaggedBuilder) = (*_BACnetLightingTransitionTaggedBuilder)(nil)

func (b *_BACnetLightingTransitionTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetLightingTransition, proprietaryValue uint32) BACnetLightingTransitionTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetLightingTransitionTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLightingTransitionTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLightingTransitionTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLightingTransitionTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLightingTransitionTaggedBuilder) WithValue(value BACnetLightingTransition) BACnetLightingTransitionTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetLightingTransitionTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetLightingTransitionTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetLightingTransitionTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLightingTransitionTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLightingTransitionTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLightingTransitionTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLightingTransitionTaggedBuilder) Build() (BACnetLightingTransitionTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLightingTransitionTagged.deepCopy(), nil
}

func (b *_BACnetLightingTransitionTaggedBuilder) MustBuild() BACnetLightingTransitionTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLightingTransitionTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLightingTransitionTaggedBuilder().(*_BACnetLightingTransitionTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLightingTransitionTaggedBuilder creates a BACnetLightingTransitionTaggedBuilder
func (b *_BACnetLightingTransitionTagged) CreateBACnetLightingTransitionTaggedBuilder() BACnetLightingTransitionTaggedBuilder {
	if b == nil {
		return NewBACnetLightingTransitionTaggedBuilder()
	}
	return &_BACnetLightingTransitionTaggedBuilder{_BACnetLightingTransitionTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLightingTransitionTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLightingTransitionTagged) GetValue() BACnetLightingTransition {
	return m.Value
}

func (m *_BACnetLightingTransitionTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetLightingTransitionTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetLightingTransition_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLightingTransitionTagged(structType any) BACnetLightingTransitionTagged {
	if casted, ok := structType.(BACnetLightingTransitionTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLightingTransitionTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLightingTransitionTagged) GetTypeName() string {
	return "BACnetLightingTransitionTagged"
}

func (m *_BACnetLightingTransitionTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetLightingTransitionTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLightingTransitionTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLightingTransitionTagged, error) {
	return BACnetLightingTransitionTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLightingTransitionTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLightingTransitionTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLightingTransitionTagged, error) {
		return BACnetLightingTransitionTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLightingTransitionTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLightingTransitionTagged, error) {
	v, err := (&_BACnetLightingTransitionTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLightingTransitionTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLightingTransitionTagged BACnetLightingTransitionTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLightingTransitionTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLightingTransitionTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetLightingTransition](ctx, "value", readBuffer, EnsureType[BACnetLightingTransition](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetLightingTransition_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetLightingTransition_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetLightingTransitionTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLightingTransitionTagged")
	}

	return m, nil
}

func (m *_BACnetLightingTransitionTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLightingTransitionTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLightingTransitionTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLightingTransitionTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetLightingTransition](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLightingTransitionTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLightingTransitionTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLightingTransitionTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLightingTransitionTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLightingTransitionTagged) IsBACnetLightingTransitionTagged() {}

func (m *_BACnetLightingTransitionTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLightingTransitionTagged) deepCopy() *_BACnetLightingTransitionTagged {
	if m == nil {
		return nil
	}
	_BACnetLightingTransitionTaggedCopy := &_BACnetLightingTransitionTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLightingTransitionTaggedCopy
}

func (m *_BACnetLightingTransitionTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
