/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import java.util.Iterator;
import org.exolab.castor.util.OrderedHashMap;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JInterface;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JAnnotatedElementHelper
implements JAnnotatedElement {
    private OrderedHashMap _annotations;

    public final JAnnotation getAnnotation(JAnnotationType annotationType) {
        if (this._annotations == null) {
            return null;
        }
        return (JAnnotation)this._annotations.get(annotationType.getName());
    }

    public final JAnnotation[] getAnnotations() {
        if (this._annotations == null) {
            return new JAnnotation[0];
        }
        return this._annotations.values().toArray(new JAnnotation[this._annotations.size()]);
    }

    public final boolean isAnnotationPresent(JAnnotationType annotationType) {
        if (this._annotations != null) {
            return this._annotations.containsKey(annotationType.getName());
        }
        return false;
    }

    public final void addAnnotation(JAnnotation annotation) {
        if (this.isAnnotationPresent(annotation.getAnnotationType())) {
            throw new IllegalArgumentException("Annotation for '" + annotation.getAnnotationType().getName() + "' already added.");
        }
        String annotationType = annotation.getAnnotationType().getName();
        if (this._annotations == null) {
            this._annotations = new OrderedHashMap();
        }
        this._annotations.put(annotationType, annotation);
    }

    public final JAnnotation removeAnnotation(JAnnotationType annotationType) {
        if (!this.isAnnotationPresent(annotationType)) {
            throw new IllegalArgumentException("Annotation for '" + annotationType.getName() + "' not present.");
        }
        return (JAnnotation)this._annotations.remove(annotationType.getName());
    }

    public final boolean hasAnnotations() {
        if (this._annotations != null) {
            return this._annotations.size() > 0;
        }
        return false;
    }

    public final boolean printAnnotations(JSourceWriter jsw) {
        boolean printed = false;
        if (this._annotations != null) {
            Iterator annotations = this._annotations.values().iterator();
            while (annotations.hasNext()) {
                JAnnotation annotation = (JAnnotation)annotations.next();
                annotation.print(jsw);
                jsw.writeln();
                printed = true;
            }
        }
        return printed;
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JAnnotatedElementHelper.test1(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test2(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test3(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test4(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test5(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test6(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test7(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test8(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test9(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotatedElementHelper.test10(jsw);
        jsw.flush();
    }

    private static void test1(JSourceWriter jsw) {
        JAnnotation endorsers = JAnnotatedElementHelper.makeTestEndorserAnnotation();
        JClass lollipop = new JClass("Lollipop");
        lollipop.addAnnotation(endorsers);
        lollipop.print(jsw);
    }

    private static void test2(JSourceWriter jsw) {
        JAnnotation copyright = JAnnotatedElementHelper.makeTestCopyrightAnnotation();
        JAnnotation endorsers = JAnnotatedElementHelper.makeTestEndorserAnnotation();
        JClass lollipop = new JClass("Lollipop");
        lollipop.addAnnotation(endorsers);
        lollipop.addAnnotation(copyright);
        lollipop.print(jsw);
    }

    private static void test3(JSourceWriter jsw) {
        JAnnotation endorsers = JAnnotatedElementHelper.makeTestEndorserAnnotation();
        JInterface lollipop = new JInterface("Lollipop");
        lollipop.addAnnotation(endorsers);
        lollipop.print(jsw);
    }

    private static void test4(JSourceWriter jsw) {
        JAnnotationType suppressWarningsType = new JAnnotationType("org.xyz.SuppressWarnings");
        JAnnotation suppressWarnings = new JAnnotation(suppressWarningsType);
        JField field = new JField(new JClass("DocumentHandler"), "documentHandler");
        field.addAnnotation(suppressWarnings);
        JClass timeMachine = new JClass("EventProducer");
        timeMachine.addField(field);
        timeMachine.print(jsw);
    }

    private static void test5(JSourceWriter jsw) {
        JAnnotationType suppressWarningsType = new JAnnotationType("SuppressWarnings");
        JAnnotation suppressWarnings = new JAnnotation(suppressWarningsType);
        JField field = new JField(new JClass("DocumentHandler"), "documentHandler");
        field.getModifiers().setStatic(true);
        field.getModifiers().makePublic();
        field.addAnnotation(suppressWarnings);
        JInterface timeMachine = new JInterface("TimeMachine");
        timeMachine.addField(field);
        timeMachine.print(jsw);
    }

    private static void test6(JSourceWriter jsw) {
        JAnnotation requestForEnhancement = JAnnotatedElementHelper.makeTestRFEAnnotation();
        JMethod travelThroughTime = new JMethod("travelThroughTime");
        travelThroughTime.addAnnotation(requestForEnhancement);
        travelThroughTime.addParameter(new JParameter(new JClass("Date"), "date"));
        JClass timeMachine = new JClass("TimeMachine");
        timeMachine.addMethod(travelThroughTime);
        timeMachine.print(jsw);
    }

    private static void test7(JSourceWriter jsw) {
        JAnnotation requestForEnhancement = JAnnotatedElementHelper.makeTestRFEAnnotation();
        JMethodSignature travelThroughTime = new JMethodSignature("travelThroughTime");
        travelThroughTime.addAnnotation(requestForEnhancement);
        travelThroughTime.addParameter(new JParameter(new JClass("Date"), "date"));
        JInterface timeMachine = new JInterface("TimeMachine");
        timeMachine.addMethod(travelThroughTime);
        timeMachine.print(jsw);
    }

    private static void test8(JSourceWriter jsw) {
        JAnnotation endorsers = JAnnotatedElementHelper.makeTestEndorserAnnotation();
        JClass lollipop = new JClass("Lollipop");
        JConstructor constructor = new JConstructor(lollipop);
        constructor.addAnnotation(endorsers);
        lollipop.addConstructor(constructor);
        lollipop.print(jsw);
    }

    private static void test9(JSourceWriter jsw) {
        JAnnotationType suppressWarningsType = new JAnnotationType("org.xyz.SuppressWarnings");
        JAnnotation suppressWarnings = new JAnnotation(suppressWarningsType);
        JMethodSignature travelThroughTime = new JMethodSignature("produceEvents");
        JParameter parameter1 = new JParameter(new JClass("DocumentHandler"), "documentHandler");
        parameter1.addAnnotation(suppressWarnings);
        travelThroughTime.addParameter(parameter1);
        JParameter parameter2 = new JParameter(JType.BOOLEAN, "asDocument");
        travelThroughTime.addParameter(parameter2);
        JInterface timeMachine = new JInterface("EventProducer");
        timeMachine.addMethod(travelThroughTime);
        timeMachine.print(jsw);
    }

    private static void test10(JSourceWriter jsw) {
        JAnnotationType suppressWarningsType = new JAnnotationType("SuppressWarnings");
        JAnnotation suppressWarnings = new JAnnotation(suppressWarningsType);
        JParameter parameter1 = new JParameter(new JClass("DocumentHandler"), "documentHandler");
        JParameter parameter2 = new JParameter(JType.BOOLEAN, "asDocument");
        parameter1.addAnnotation(suppressWarnings);
        JClass lollipop = new JClass("Lollipop");
        JConstructor constructor = new JConstructor(lollipop);
        constructor.addParameter(parameter1);
        constructor.addParameter(parameter2);
        lollipop.addConstructor(constructor);
        lollipop.print(jsw);
    }

    private static JAnnotation makeTestCopyrightAnnotation() {
        JAnnotationType copyrightType = new JAnnotationType("org.xyz.Copyright");
        JAnnotation copyright = new JAnnotation(copyrightType);
        copyright.setValue("\"2002 Yoyodyne Propulsion Systems, Inc., All rights reserved.\"");
        return copyright;
    }

    private static JAnnotation makeTestEndorserAnnotation() {
        JAnnotationType endorsersType = new JAnnotationType("org.xyz.Endorsers");
        JAnnotation endorsers = new JAnnotation(endorsersType);
        endorsers.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        return endorsers;
    }

    private static JAnnotation makeTestRFEAnnotation() {
        JAnnotationType requestForEnhancementType = new JAnnotationType("org.xyz.RequestForEnhancement");
        JAnnotation requestForEnhancement = new JAnnotation(requestForEnhancementType);
        requestForEnhancement.setElementValue("id", "2868724");
        requestForEnhancement.setElementValue("synopsis", "\"Provide time-travel functionality\"");
        requestForEnhancement.setElementValue("engineer", "\"Mr. Peabody\"");
        requestForEnhancement.setElementValue("date", "\"4/1/2004\"");
        return requestForEnhancement;
    }
}

