/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationBasic;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;

public class PipelineSpecificationBasic
implements IPipelineSpecificationBasic {
    protected final IJobDescription job;
    protected final int[][] pipelineStageChildren;
    protected final int[] outputs;

    public PipelineSpecificationBasic(IJobDescription job) {
        int prerequisite;
        int i;
        this.job = job;
        this.pipelineStageChildren = new int[job.countPipelineStages() + 1][];
        int[] childrenCount = new int[this.pipelineStageChildren.length];
        int outputCount = 0;
        for (i = 0; i < job.countPipelineStages(); ++i) {
            prerequisite = job.getPipelineStagePrerequisite(i);
            int n = prerequisite + 1;
            childrenCount[n] = childrenCount[n] + 1;
            if (!job.getPipelineStageIsOutputConnection(i)) continue;
            ++outputCount;
        }
        for (i = 0; i < this.pipelineStageChildren.length; ++i) {
            this.pipelineStageChildren[i] = new int[childrenCount[i]];
            childrenCount[i] = 0;
        }
        this.outputs = new int[outputCount];
        outputCount = 0;
        for (i = 0; i < job.countPipelineStages(); ++i) {
            prerequisite = job.getPipelineStagePrerequisite(i);
            int n = prerequisite + 1;
            int n2 = childrenCount[n];
            childrenCount[n] = n2 + 1;
            this.pipelineStageChildren[prerequisite + 1][n2] = i;
            if (!job.getPipelineStageIsOutputConnection(i)) continue;
            this.outputs[outputCount++] = i;
        }
    }

    public int getStageCount() {
        return this.job.countPipelineStages();
    }

    public int[] getStageChildren(int stage) {
        return this.pipelineStageChildren[stage + 1];
    }

    public int getStageParent(int stage) {
        return this.job.getPipelineStagePrerequisite(stage);
    }

    public String getStageConnectionName(int stage) {
        return this.job.getPipelineStageConnectionName(stage);
    }

    public boolean checkStageOutputConnection(int stage) {
        return this.job.getPipelineStageIsOutputConnection(stage);
    }

    public int getOutputCount() {
        return this.outputs.length;
    }

    public int getOutputStage(int index) {
        return this.outputs[index];
    }
}

