/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.TransactionalCrawlerInitializationCommand;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;

public class UnRegister
extends TransactionalCrawlerInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegister.java 988245 2010-08-23 18:39:35Z kwright $";
    private final String className;

    public UnRegister(String className) {
        this.className = className;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IConnectorManager mgr = ConnectorManagerFactory.make(tc);
        IJobManager jobManager = JobManagerFactory.make(tc);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(tc);
        String[] connectionNames = connManager.findConnectionsForConnector(this.className);
        jobManager.noteConnectorDeregistration(connectionNames);
        mgr.unregisterConnector(this.className);
        Logging.root.info((Object)("Successfully unregistered connector '" + this.className + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: UnRegister <classname>");
            System.exit(1);
        }
        String className = args[0];
        try {
            UnRegister unRegister = new UnRegister(className);
            unRegister.execute();
            System.err.println("Successfully unregistered connector '" + className + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

