/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.csws;

import com.opentext.ecm.api.OTAuthentication;
import com.opentext.livelink.service.core.Authentication;
import com.opentext.livelink.service.core.Authentication_Service;
import com.opentext.livelink.service.core.ContentService;
import com.opentext.livelink.service.core.ContentService_Service;
import com.opentext.livelink.service.core.PageHandle;
import com.opentext.livelink.service.docman.AttributeGroupDefinition;
import com.opentext.livelink.service.docman.CategoryInheritance;
import com.opentext.livelink.service.docman.DocumentManagement;
import com.opentext.livelink.service.docman.DocumentManagement_Service;
import com.opentext.livelink.service.docman.GetNodesInContainerOptions;
import com.opentext.livelink.service.docman.Node;
import com.opentext.livelink.service.docman.NodeRights;
import com.opentext.livelink.service.docman.Version;
import com.opentext.livelink.service.memberservice.Member;
import com.opentext.livelink.service.memberservice.MemberRight;
import com.opentext.livelink.service.memberservice.MemberSearchOptions;
import com.opentext.livelink.service.memberservice.MemberSearchResults;
import com.opentext.livelink.service.memberservice.MemberService;
import com.opentext.livelink.service.memberservice.MemberService_Service;
import com.opentext.livelink.service.memberservice.SearchColumn;
import com.opentext.livelink.service.memberservice.SearchFilter;
import com.opentext.livelink.service.memberservice.SearchMatching;
import com.opentext.livelink.service.memberservice.SearchScope;
import com.opentext.livelink.service.memberservice.User;
import com.opentext.livelink.service.searchservices.SGraph;
import com.opentext.livelink.service.searchservices.SResultPage;
import com.opentext.livelink.service.searchservices.SearchService;
import com.opentext.livelink.service.searchservices.SearchService_Service;
import com.opentext.livelink.service.searchservices.SingleSearchRequest;
import com.opentext.livelink.service.searchservices.SingleSearchResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HttpConduitConfig;
import org.apache.cxf.transport.http.HttpConduitFeature;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class CswsSession {
    private static final String ECM_API_NAMESPACE = "urn:api.ecm.opentext.com";
    private static final String CORE_NAMESPACE = "urn:Core.service.livelink.opentext.com";
    private final String userName;
    private final String password;
    private final long sessionExpirationInterval;
    private final Authentication_Service authService;
    private final ContentService_Service contentServiceService;
    private final DocumentManagement_Service documentManagementService;
    private final MemberService_Service memberServiceService;
    private final SearchService_Service searchServiceService;
    private final Authentication authClientHandle;
    private final DocumentManagement documentManagementHandle;
    private final ContentService contentServiceHandle;
    private final MemberService memberServiceHandle;
    private final SearchService searchServiceHandle;
    private List<? extends String> rootNodeTypes = null;
    private Map<String, Node> workspaceTypeNodes = new HashMap<String, Node>();
    private static final String sslSocketFactoryProperty = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
    private long currentSessionExpiration = -1L;
    private String currentAuthToken = null;

    public CswsSession(String userName, String password, IKeystoreManager keystore, long sessionExpirationInterval, String authenticationServiceURL, String documentManagementServiceURL, String contentServiceServiceURL, String memberServiceServiceURL, String searchServiceServiceURL) throws ManifoldCFException {
        this.userName = userName;
        this.password = password;
        this.sessionExpirationInterval = sessionExpirationInterval;
        TLSClientParameters tlsConfig = new TLSClientParameters();
        if (keystore != null) {
            tlsConfig.setTrustManagers(keystore.getTrustManagers());
        }
        HttpConduitConfig config = new HttpConduitConfig();
        config.setTlsClientParameters(tlsConfig);
        HttpConduitFeature conduitFeature = new HttpConduitFeature();
        conduitFeature.setConduitConfig(config);
        ClassLoader savedCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.authService = authenticationServiceURL != null ? new Authentication_Service(new URL(authenticationServiceURL + "?wsdl"), new WebServiceFeature[]{conduitFeature}) : null;
            this.documentManagementService = documentManagementServiceURL != null ? new DocumentManagement_Service(new URL(documentManagementServiceURL + "?wsdl"), new WebServiceFeature[]{conduitFeature}) : null;
            this.contentServiceService = contentServiceServiceURL != null ? new ContentService_Service(new URL(contentServiceServiceURL + "?wsdl"), new WebServiceFeature[]{conduitFeature}) : null;
            this.memberServiceService = memberServiceServiceURL != null ? new MemberService_Service(new URL(memberServiceServiceURL + "?wsdl"), new WebServiceFeature[]{conduitFeature}) : null;
            this.searchServiceService = searchServiceServiceURL != null ? new SearchService_Service(new URL(searchServiceServiceURL + "?wsdl"), new WebServiceFeature[]{conduitFeature}) : null;
        }
        catch (WebServiceException e) {
            throw new ManifoldCFException("Error initializing web services: " + e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Malformed URL: " + e.getMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCl);
        }
        if (this.authService != null) {
            this.authClientHandle = this.authService.getBasicHttpBindingAuthentication();
            ((BindingProvider)this.authClientHandle).getRequestContext().put("javax.xml.ws.service.endpoint.address", authenticationServiceURL);
        } else {
            this.authClientHandle = null;
        }
        if (this.documentManagementService != null) {
            this.documentManagementHandle = this.documentManagementService.getBasicHttpBindingDocumentManagement();
            ((BindingProvider)this.documentManagementHandle).getRequestContext().put("javax.xml.ws.service.endpoint.address", documentManagementServiceURL);
        } else {
            this.documentManagementHandle = null;
        }
        if (this.contentServiceService != null) {
            this.contentServiceHandle = this.contentServiceService.getBasicHttpBindingContentService();
            ((BindingProvider)this.contentServiceHandle).getRequestContext().put("javax.xml.ws.service.endpoint.address", contentServiceServiceURL);
        } else {
            this.contentServiceHandle = null;
        }
        if (this.memberServiceService != null) {
            this.memberServiceHandle = this.memberServiceService.getBasicHttpBindingMemberService();
            ((BindingProvider)this.memberServiceHandle).getRequestContext().put("javax.xml.ws.service.endpoint.address", memberServiceServiceURL);
        } else {
            this.memberServiceHandle = null;
        }
        if (this.searchServiceService != null) {
            this.searchServiceHandle = this.searchServiceService.getBasicHttpBindingSearchService();
            ((BindingProvider)this.searchServiceHandle).getRequestContext().put("javax.xml.ws.service.endpoint.address", searchServiceServiceURL);
        } else {
            this.searchServiceHandle = null;
        }
    }

    public DocumentManagement getDocumentManagementHandle() {
        return this.documentManagementHandle;
    }

    public ContentService getContentServiceHandle() {
        return this.contentServiceHandle;
    }

    public MemberService getMemberServiceHandle() {
        return this.memberServiceHandle;
    }

    public SearchService getSearchServiceHandle() {
        return this.searchServiceHandle;
    }

    public List<? extends String> getRootNodeTypes() throws ManifoldCFException, ServiceInterruption {
        if (this.rootNodeTypes == null) {
            try {
                this.rootNodeTypes = this.getDocumentManagementHandle().getRootNodeTypes(this.getOTAuthentication());
            }
            catch (SOAPFaultException e) {
                this.processSOAPFault(e);
            }
            catch (WebServiceException e) {
                this.processWSException(e);
            }
        }
        return this.rootNodeTypes;
    }

    public Node getRootNode(String nodeType) throws ManifoldCFException, ServiceInterruption {
        Node thisWorkspaceNode = this.workspaceTypeNodes.get(nodeType);
        if (thisWorkspaceNode == null) {
            try {
                thisWorkspaceNode = this.getDocumentManagementHandle().getRootNode(nodeType, this.getOTAuthentication());
            }
            catch (SOAPFaultException e) {
                this.processSOAPFault(e);
            }
            catch (WebServiceException e) {
                this.processWSException(e);
            }
            this.workspaceTypeNodes.put(nodeType, thisWorkspaceNode);
        }
        return thisWorkspaceNode;
    }

    public List<? extends Node> listNodes(long nodeId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().listNodes(nodeId, false, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            if (e.getFault().getFaultCode().equals("ns0:DocMan.ErrorGettingParentNode")) {
                return null;
            }
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public List<? extends Node> getChildren(long nodeId) throws ManifoldCFException, ServiceInterruption {
        GetNodesInContainerOptions gnico = new GetNodesInContainerOptions();
        gnico.setMaxDepth(0);
        gnico.setMaxResults(1000000);
        try {
            return this.getDocumentManagementHandle().getNodesInContainer(nodeId, gnico, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            if (e.getFault().getFaultCode().equals("ns0:DocMan.ErrorGettingParentNode")) {
                return null;
            }
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public List<? extends CategoryInheritance> getCategoryInheritance(long parentId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getCategoryInheritance(parentId, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public List<? extends AttributeGroupDefinition> getCategoryDefinitions(List<Long> categoryIDs) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getCategoryDefinitions(categoryIDs, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public Node getNode(long nodeId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getNode(nodeId, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public Node getNodeByPath(long rootNode, List<String> colonSeparatedPath) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getNodeByPath(rootNode, colonSeparatedPath, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public NodeRights getNodeRights(long nodeId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getNodeRights(nodeId, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public Version getVersion(long nodeId, long version) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getVersion(nodeId, version, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            if (e.getFault().getFaultCode().equals("ns0:DocMan.VersionRetrievalError")) {
                return null;
            }
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public AttributeGroupDefinition getCategoryDefinition(long catId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getDocumentManagementHandle().getCategoryDefinition(catId, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public User getUserByLoginName(String userName) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getMemberServiceHandle().getUserByLoginName(userName, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public Member getMemberByLoginName(String memberName) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getMemberServiceHandle().getMemberByLoginName(memberName, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public List<? extends MemberRight> listRightsByMemberId(long memberId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getMemberServiceHandle().listRightsByID(memberId, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public Member getMember(long memberId) throws ManifoldCFException, ServiceInterruption {
        try {
            return this.getMemberServiceHandle().getMemberById(memberId, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public void getVersionContents(long nodeId, long version, OutputStream os) throws ManifoldCFException, ServiceInterruption {
        try {
            Holder<OTAuthentication> auth = this.getOTAuthentication();
            String contextID = this.getDocumentManagementHandle().getVersionContentsContext(nodeId, version, auth);
            DataHandler dataHandler = this.getContentServiceHandle().downloadContent(contextID, auth);
            dataHandler.writeTo(os);
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
        }
        catch (IOException e) {
            this.processIOException(e);
        }
        catch (WebServiceException e) {
            this.processWSException(e);
        }
    }

    public PageHandle getAllUsers() throws ManifoldCFException, ServiceInterruption {
        MemberSearchOptions srchMemOptions = new MemberSearchOptions();
        srchMemOptions.setFilter(SearchFilter.USER);
        srchMemOptions.setScope(SearchScope.SYSTEM);
        srchMemOptions.setColumn(SearchColumn.NAME);
        srchMemOptions.setMatching(SearchMatching.STARTSWITH);
        srchMemOptions.setSearch("");
        try {
            return this.getMemberServiceHandle().searchForMembers(srchMemOptions, this.getOTAuthentication());
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public List<? extends Member> getNextUserSearchResults(PageHandle pgHandle) throws ManifoldCFException, ServiceInterruption {
        try {
            MemberSearchResults msr = this.getMemberServiceHandle().getSearchResults(pgHandle, this.getOTAuthentication());
            if (msr == null) {
                return null;
            }
            List<Member> rval = msr.getMembers();
            if (rval == null || rval.size() == 0) {
                return null;
            }
            return rval;
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public List<? extends SGraph> searchFor(long parentID, String[] returnColumns, String dataCollection, String searchSpec, String orderingColumn, int start, int count) throws ManifoldCFException, ServiceInterruption {
        try {
            SingleSearchRequest singleSrchReq = new SingleSearchRequest();
            singleSrchReq.setDataCollectionSpec(dataCollection);
            singleSrchReq.setQueryLanguage("Livelink Search API V1");
            singleSrchReq.setFirstResultToRetrieve(start + 1);
            singleSrchReq.setNumResultsToRetrieve(count);
            if (orderingColumn != null) {
                singleSrchReq.setResultOrderSpec("sortByRegion=" + orderingColumn + "&sortDirection=ascending");
            }
            singleSrchReq.setResultSetSpec("where1=(\"OTParentID\":" + parentID + " AND (" + searchSpec + "))&lookfor1=complexquery");
            for (String returnColumn : returnColumns) {
                singleSrchReq.getResultTransformationSpec().add(returnColumn);
            }
            SingleSearchResponse results = this.getSearchServiceHandle().search(singleSrchReq, "", this.getOTAuthentication());
            if (results == null) {
                return null;
            }
            SResultPage srp = results.getResults();
            if (srp == null) {
                return null;
            }
            return srp.getItem();
        }
        catch (SOAPFaultException e) {
            this.processSOAPFault(e);
            return null;
        }
        catch (WebServiceException e) {
            this.processWSException(e);
            return null;
        }
    }

    public Holder<OTAuthentication> getOTAuthentication() throws ManifoldCFException, ServiceInterruption {
        String authToken = this.getAuthToken();
        Holder holder = new Holder();
        OTAuthentication otAuth = new OTAuthentication();
        otAuth.setAuthenticationToken(authToken);
        holder.value = otAuth;
        return holder;
    }

    private String getAuthToken() throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        if (this.currentSessionExpiration == -1L || currentTime > this.currentSessionExpiration) {
            this.currentSessionExpiration = -1L;
            this.currentAuthToken = null;
            try {
                this.currentAuthToken = this.authClientHandle.authenticateUser(this.userName, this.password);
            }
            catch (SOAPFaultException e) {
                this.processSOAPFault(e);
            }
            catch (WebServiceException e) {
                this.processWSException(e);
            }
            this.currentSessionExpiration = currentTime + this.sessionExpirationInterval;
        }
        return this.currentAuthToken;
    }

    private void processIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
    }

    private void processSOAPFault(SOAPFaultException e) throws ManifoldCFException, ServiceInterruption {
        throw new ManifoldCFException("SOAP exception: " + e.getMessage(), (Throwable)e);
    }

    private void processWSException(WebServiceException e) throws ManifoldCFException, ServiceInterruption {
        throw new ManifoldCFException("Web service communication issue: " + e.getMessage(), (Throwable)e);
    }
}

