/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;

public class TsFileNameGenerator {
    private static FSFactory fsFactory = FSFactoryProducer.getFSFactory();

    public static String generateNewTsFilePath(String tsFileDir, long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount) {
        return tsFileDir + File.separator + TsFileNameGenerator.generateNewTsFileName(time, version, innerSpaceCompactionCount, crossSpaceCompactionCount);
    }

    public static String generateNewTsFilePathWithMkdir(boolean sequence, String logicalStorageGroup, String virtualStorageGroup, long timePartitionId, long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount) throws DiskSpaceInsufficientException {
        return TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, logicalStorageGroup, virtualStorageGroup, timePartitionId, time, version, innerSpaceCompactionCount, crossSpaceCompactionCount, 0, ".tsfile");
    }

    public static String generateNewTsFilePathWithMkdir(boolean sequence, String logicalStorageGroup, String virtualStorageGroup, long timePartitionId, long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount, int tierLevel, String customSuffix) throws DiskSpaceInsufficientException {
        String tsFileDir = TsFileNameGenerator.generateTsFileDir(sequence, logicalStorageGroup, virtualStorageGroup, timePartitionId, tierLevel);
        fsFactory.getFile(tsFileDir).mkdirs();
        return tsFileDir + File.separator + TsFileNameGenerator.generateNewTsFileName(time, version, innerSpaceCompactionCount, crossSpaceCompactionCount, customSuffix);
    }

    public static String generateTsFileDir(boolean sequence, String logicalStorageGroup, String virtualStorageGroup, long timePartitionId, int tierLevel) throws DiskSpaceInsufficientException {
        TierManager tierManager = TierManager.getInstance();
        String baseDir = tierManager.getNextFolderForTsFile(tierLevel, sequence);
        return baseDir + File.separator + logicalStorageGroup + File.separator + virtualStorageGroup + File.separator + timePartitionId;
    }

    public static String generateNewTsFileName(long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount) {
        return TsFileNameGenerator.generateNewTsFileName(time, version, innerSpaceCompactionCount, crossSpaceCompactionCount, ".tsfile");
    }

    public static String generateNewTsFileName(long time, long version, int innerSpaceCompactionCount, int crossSpaceCompactionCount, String customSuffix) {
        return time + "-" + version + "-" + innerSpaceCompactionCount + "-" + crossSpaceCompactionCount + customSuffix;
    }

    public static TsFileName getTsFileName(String fileName) throws IOException {
        Matcher matcher = TsFileName.FILE_NAME_MATCHER.matcher(fileName);
        if (matcher.find()) {
            try {
                TsFileName tsFileName = new TsFileName(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
                return tsFileName;
            }
            catch (NumberFormatException e) {
                throw new IOException("tsfile file name format is incorrect:" + fileName);
            }
        }
        throw new IOException("tsfile file name format is incorrect:" + fileName);
    }

    public static TsFileResource increaseCrossCompactionCnt(TsFileResource tsFileResource) throws IOException {
        File tsFile = tsFileResource.getTsFile();
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileNameGenerator.getTsFileName(tsFileResource.getTsFile().getName());
        tsFileName.setCrossCompactionCnt(tsFileName.getCrossCompactionCnt() + 1);
        tsFileResource.setFile(new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".tsfile"));
        return tsFileResource;
    }

    public static TsFileResource increaseInnerCompactionCnt(TsFileResource tsFileResource) throws IOException {
        File tsFile = tsFileResource.getTsFile();
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileNameGenerator.getTsFileName(tsFileResource.getTsFile().getName());
        tsFileName.setInnerCompactionCnt(tsFileName.getInnerCompactionCnt() + 1);
        tsFileResource.setFile(new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".tsfile"));
        return tsFileResource;
    }

    public static File increaseCrossCompactionCnt(File tsFile) throws IOException {
        String path = tsFile.getParent();
        TsFileName tsFileName = TsFileNameGenerator.getTsFileName(tsFile.getName());
        tsFileName.setCrossCompactionCnt(tsFileName.getCrossCompactionCnt() + 1);
        return new File(path, tsFileName.time + "-" + tsFileName.version + "-" + tsFileName.innerCompactionCnt + "-" + tsFileName.crossCompactionCnt + ".tsfile");
    }

    public static List<TsFileResource> getCrossCompactionTargetFileResources(List<TsFileResource> seqResources) throws IOException, DiskSpaceInsufficientException {
        ArrayList<TsFileResource> targetFileResources = new ArrayList<TsFileResource>();
        for (TsFileResource resource : seqResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            tsFileName.setCrossCompactionCnt(tsFileName.getCrossCompactionCnt() + 1);
            targetFileResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePathWithMkdir(resource.isSeq(), resource.getDatabaseName(), resource.getDataRegionId(), resource.getTimePartition(), tsFileName.time, tsFileName.version, tsFileName.innerCompactionCnt, tsFileName.crossCompactionCnt, resource.getTierLevel(), ".cross")), TsFileResourceStatus.COMPACTING));
        }
        return targetFileResources;
    }

    public static TsFileResource getInnerCompactionTargetFileResource(List<TsFileResource> tsFileResources, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        long minVersion = Long.MAX_VALUE;
        long maxVersion = Long.MIN_VALUE;
        long maxInnerMergeCount = Long.MIN_VALUE;
        long maxCrossMergeCount = Long.MIN_VALUE;
        int maxTierLevel = 0;
        for (TsFileResource resource : tsFileResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            minTime = Math.min(tsFileName.time, minTime);
            maxTime = Math.max(tsFileName.time, maxTime);
            minVersion = Math.min(tsFileName.version, minVersion);
            maxVersion = Math.max(tsFileName.version, maxVersion);
            maxInnerMergeCount = Math.max((long)tsFileName.innerCompactionCnt, maxInnerMergeCount);
            maxCrossMergeCount = Math.max((long)tsFileName.crossCompactionCnt, maxCrossMergeCount);
            maxTierLevel = Math.max(resource.getTierLevel(), maxTierLevel);
        }
        TsFileResource resource = sequence ? new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, tsFileResources.get(0).getDatabaseName(), tsFileResources.get(0).getDataRegionId(), tsFileResources.get(0).getTimePartition(), minTime, minVersion, (int)maxInnerMergeCount + 1, (int)maxCrossMergeCount, maxTierLevel, ".inner")), TsFileResourceStatus.COMPACTING) : new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, tsFileResources.get(0).getDatabaseName(), tsFileResources.get(0).getDataRegionId(), tsFileResources.get(0).getTimePartition(), maxTime, maxVersion, (int)maxInnerMergeCount + 1, (int)maxCrossMergeCount, maxTierLevel, ".inner")), TsFileResourceStatus.COMPACTING);
        resource.setSeq(sequence);
        return resource;
    }

    public static List<TsFileResource> getNewInnerCompactionTargetFileResources(List<TsFileResource> tsFileResources, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        long maxInnerCompactionCount = Long.MIN_VALUE;
        long maxCrossMergeCount = Long.MIN_VALUE;
        int maxTierLevel = 0;
        for (TsFileResource resource : tsFileResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            maxInnerCompactionCount = Math.max((long)tsFileName.innerCompactionCnt, maxInnerCompactionCount);
            maxCrossMergeCount = Math.max((long)tsFileName.crossCompactionCnt, maxCrossMergeCount);
            maxTierLevel = Math.max(resource.getTierLevel(), maxTierLevel);
        }
        ArrayList<TsFileResource> targetResources = new ArrayList<TsFileResource>(tsFileResources.size());
        for (TsFileResource resource : tsFileResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            TsFileResource targetResource = new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, tsFileResources.get(0).getDatabaseName(), tsFileResources.get(0).getDataRegionId(), tsFileResources.get(0).getTimePartition(), tsFileName.time, tsFileName.version, (int)maxInnerCompactionCount + 1, (int)maxCrossMergeCount, maxTierLevel, ".inner")), TsFileResourceStatus.COMPACTING);
            targetResource.setSeq(sequence);
            targetResources.add(targetResource);
        }
        return targetResources;
    }

    public static TsFileResource getSettleCompactionTargetFileResources(List<TsFileResource> tsFileResources, boolean sequence) throws IOException {
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        long minVersion = Long.MAX_VALUE;
        long maxVersion = Long.MIN_VALUE;
        long maxInnerMergeCount = Long.MIN_VALUE;
        long maxCrossMergeCount = Long.MIN_VALUE;
        for (TsFileResource resource : tsFileResources) {
            TsFileName tsFileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
            minTime = Math.min(tsFileName.time, minTime);
            maxTime = Math.max(tsFileName.time, maxTime);
            minVersion = Math.min(tsFileName.version, minVersion);
            maxVersion = Math.max(tsFileName.version, maxVersion);
            maxInnerMergeCount = Math.max((long)tsFileName.innerCompactionCnt, maxInnerMergeCount);
            maxCrossMergeCount = Math.max((long)tsFileName.crossCompactionCnt, maxCrossMergeCount);
        }
        return sequence ? new TsFileResource(new File(tsFileResources.get(0).getTsFile().getParent(), minTime + "-" + minVersion + "-" + (maxInnerMergeCount + 1L) + "-" + maxCrossMergeCount + ".settle"), TsFileResourceStatus.COMPACTING) : new TsFileResource(new File(tsFileResources.get(0).getTsFile().getParent(), maxTime + "-" + maxVersion + "-" + (maxInnerMergeCount + 1L) + "-" + maxCrossMergeCount + ".settle"), TsFileResourceStatus.COMPACTING);
    }

    public static class TsFileName {
        private static final String FILE_NAME_PATTERN = "(\\d+)-(\\d+)-(\\d+)-(\\d+).tsfile$";
        private static final Pattern FILE_NAME_MATCHER = Pattern.compile("(\\d+)-(\\d+)-(\\d+)-(\\d+).tsfile$");
        private long time;
        private long version;
        private int innerCompactionCnt;
        private int crossCompactionCnt;

        public TsFileName(long time, long version, int innerCompactionCnt, int crossCompactionCnt) {
            this.time = time;
            this.version = version;
            this.innerCompactionCnt = innerCompactionCnt;
            this.crossCompactionCnt = crossCompactionCnt;
        }

        public long getTime() {
            return this.time;
        }

        public long getVersion() {
            return this.version;
        }

        public int getInnerCompactionCnt() {
            return this.innerCompactionCnt;
        }

        public int getCrossCompactionCnt() {
            return this.crossCompactionCnt;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public void setInnerCompactionCnt(int innerCompactionCnt) {
            this.innerCompactionCnt = innerCompactionCnt;
        }

        public void setCrossCompactionCnt(int crossCompactionCnt) {
            this.crossCompactionCnt = crossCompactionCnt;
        }
    }
}

