/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RelativePathElement
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=537");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=538");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=539");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15188");
    private final NodeId referenceTypeId;
    private final Boolean isInverse;
    private final Boolean includeSubtypes;
    private final QualifiedName targetName;

    public RelativePathElement(NodeId referenceTypeId, Boolean isInverse, Boolean includeSubtypes, QualifiedName targetName) {
        this.referenceTypeId = referenceTypeId;
        this.isInverse = isInverse;
        this.includeSubtypes = includeSubtypes;
        this.targetName = targetName;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsInverse() {
        return this.isInverse;
    }

    public Boolean getIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public QualifiedName getTargetName() {
        return this.targetName;
    }

    protected RelativePathElement(RelativePathElementBuilder<?, ?> b) {
        super(b);
        this.referenceTypeId = ((RelativePathElementBuilder)b).referenceTypeId;
        this.isInverse = ((RelativePathElementBuilder)b).isInverse;
        this.includeSubtypes = ((RelativePathElementBuilder)b).includeSubtypes;
        this.targetName = ((RelativePathElementBuilder)b).targetName;
    }

    public static RelativePathElementBuilder<?, ?> builder() {
        return new RelativePathElementBuilderImpl();
    }

    public RelativePathElementBuilder<?, ?> toBuilder() {
        return new RelativePathElementBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelativePathElement)) {
            return false;
        }
        RelativePathElement other = (RelativePathElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isInverse = this.getIsInverse();
        Boolean other$isInverse = other.getIsInverse();
        if (this$isInverse == null ? other$isInverse != null : !((Object)this$isInverse).equals(other$isInverse)) {
            return false;
        }
        Boolean this$includeSubtypes = this.getIncludeSubtypes();
        Boolean other$includeSubtypes = other.getIncludeSubtypes();
        if (this$includeSubtypes == null ? other$includeSubtypes != null : !((Object)this$includeSubtypes).equals(other$includeSubtypes)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        QualifiedName this$targetName = this.getTargetName();
        QualifiedName other$targetName = other.getTargetName();
        return !(this$targetName == null ? other$targetName != null : !((Object)this$targetName).equals(other$targetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelativePathElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isInverse = this.getIsInverse();
        result = result * 59 + ($isInverse == null ? 43 : ((Object)$isInverse).hashCode());
        Boolean $includeSubtypes = this.getIncludeSubtypes();
        result = result * 59 + ($includeSubtypes == null ? 43 : ((Object)$includeSubtypes).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        QualifiedName $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : ((Object)$targetName).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RelativePathElement(referenceTypeId=" + this.getReferenceTypeId() + ", isInverse=" + this.getIsInverse() + ", includeSubtypes=" + this.getIncludeSubtypes() + ", targetName=" + this.getTargetName() + ")";
    }

    private static final class RelativePathElementBuilderImpl
    extends RelativePathElementBuilder<RelativePathElement, RelativePathElementBuilderImpl> {
        private RelativePathElementBuilderImpl() {
        }

        @Override
        protected RelativePathElementBuilderImpl self() {
            return this;
        }

        @Override
        public RelativePathElement build() {
            return new RelativePathElement(this);
        }
    }

    public static abstract class RelativePathElementBuilder<C extends RelativePathElement, B extends RelativePathElementBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId referenceTypeId;
        private Boolean isInverse;
        private Boolean includeSubtypes;
        private QualifiedName targetName;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RelativePathElementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RelativePathElement instance, RelativePathElementBuilder<?, ?> b) {
            b.referenceTypeId(instance.referenceTypeId);
            b.isInverse(instance.isInverse);
            b.includeSubtypes(instance.includeSubtypes);
            b.targetName(instance.targetName);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B isInverse(Boolean isInverse) {
            this.isInverse = isInverse;
            return (B)this.self();
        }

        public B includeSubtypes(Boolean includeSubtypes) {
            this.includeSubtypes = includeSubtypes;
            return (B)this.self();
        }

        public B targetName(QualifiedName targetName) {
            this.targetName = targetName;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RelativePathElement.RelativePathElementBuilder(super=" + super.toString() + ", referenceTypeId=" + this.referenceTypeId + ", isInverse=" + this.isInverse + ", includeSubtypes=" + this.includeSubtypes + ", targetName=" + this.targetName + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RelativePathElement> {
        @Override
        public Class<RelativePathElement> getType() {
            return RelativePathElement.class;
        }

        @Override
        public RelativePathElement decode(SerializationContext context, UaDecoder decoder) {
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isInverse = decoder.readBoolean("IsInverse");
            Boolean includeSubtypes = decoder.readBoolean("IncludeSubtypes");
            QualifiedName targetName = decoder.readQualifiedName("TargetName");
            return new RelativePathElement(referenceTypeId, isInverse, includeSubtypes, targetName);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RelativePathElement value) {
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IsInverse", value.getIsInverse());
            encoder.writeBoolean("IncludeSubtypes", value.getIncludeSubtypes());
            encoder.writeQualifiedName("TargetName", value.getTargetName());
        }
    }
}

