/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3RequestUtil;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.metrics.MetricsContext;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

abstract class BaseS3File {
    private final S3Client client;
    private final S3AsyncClient asyncClient;
    private final S3URI uri;
    private final S3FileIOProperties s3FileIOProperties;
    private HeadObjectResponse metadata;
    private final MetricsContext metrics;

    BaseS3File(S3Client client, S3AsyncClient asyncClient, S3URI uri, S3FileIOProperties s3FileIOProperties, MetricsContext metrics) {
        this.client = client;
        this.asyncClient = asyncClient;
        this.uri = uri;
        this.s3FileIOProperties = s3FileIOProperties;
        this.metrics = metrics;
    }

    public String location() {
        return this.uri.location();
    }

    S3Client client() {
        return this.client;
    }

    S3AsyncClient asyncClient() {
        return this.asyncClient;
    }

    S3URI uri() {
        return this.uri;
    }

    public S3FileIOProperties s3FileIOProperties() {
        return this.s3FileIOProperties;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    public boolean exists() {
        try {
            return this.getObjectMetadata() != null;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    protected HeadObjectResponse getObjectMetadata() throws S3Exception {
        if (this.metadata == null) {
            HeadObjectRequest.Builder requestBuilder = HeadObjectRequest.builder().bucket(this.uri().bucket()).key(this.uri().key());
            S3RequestUtil.configureEncryption(this.s3FileIOProperties, requestBuilder);
            this.metadata = this.client().headObject((HeadObjectRequest)requestBuilder.build());
        }
        return this.metadata;
    }

    public String toString() {
        return this.uri.toString();
    }
}

