/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.auth.AuthenticationConfiguration;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;
import org.apache.polaris.service.auth.JWTRSAKeyPair;
import org.apache.polaris.service.auth.KeyProvider;
import org.apache.polaris.service.auth.LocalRSAKeyProvider;
import org.apache.polaris.service.auth.PemUtils;
import org.apache.polaris.service.auth.TokenBroker;
import org.apache.polaris.service.auth.TokenBrokerFactory;

@ApplicationScoped
@Identifier(value="rsa-key-pair")
public class JWTRSAKeyPairFactory
implements TokenBrokerFactory {
    private final MetaStoreManagerFactory metaStoreManagerFactory;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final ConcurrentMap<String, JWTRSAKeyPair> tokenBrokers;

    @Inject
    public JWTRSAKeyPairFactory(MetaStoreManagerFactory metaStoreManagerFactory, AuthenticationConfiguration authenticationConfiguration) {
        this.tokenBrokers = new ConcurrentHashMap<String, JWTRSAKeyPair>();
        this.metaStoreManagerFactory = metaStoreManagerFactory;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public TokenBroker apply(RealmContext realmContext) {
        return (TokenBroker)this.tokenBrokers.computeIfAbsent(realmContext.getRealmIdentifier(), k -> this.createTokenBroker(realmContext));
    }

    private JWTRSAKeyPair createTokenBroker(RealmContext realmContext) {
        AuthenticationRealmConfiguration config = this.authenticationConfiguration.forRealm(realmContext);
        Duration maxTokenGeneration = config.tokenBroker().maxTokenGeneration();
        KeyProvider keyProvider = config.tokenBroker().rsaKeyPair().map(this::fileSystemKeyPair).orElseGet(this::generateEphemeralKeyPair);
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
        return new JWTRSAKeyPair(metaStoreManager, (int)maxTokenGeneration.toSeconds(), keyProvider);
    }

    private KeyProvider fileSystemKeyPair(AuthenticationRealmConfiguration.TokenBrokerConfiguration.RSAKeyPairConfiguration config) {
        return LocalRSAKeyProvider.fromFiles((Path)config.publicKeyFile(), (Path)config.privateKeyFile());
    }

    private KeyProvider generateEphemeralKeyPair() {
        try {
            return new LocalRSAKeyProvider(PemUtils.generateKeyPair());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public JWTRSAKeyPairFactory() {
    }
}

