/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hive.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtilities {

    public static abstract class ExponentiallyDecayingBatchWork<T>
    implements ExponentialBackOffRetry<T> {
        private int batchSize;
        private final int decayingFactor;
        private int maxRetries;
        private static final Logger LOG = LoggerFactory.getLogger(ExponentiallyDecayingBatchWork.class);

        public ExponentiallyDecayingBatchWork(int batchSize, int reducingFactor, int maxRetries) {
            if (batchSize <= 0) {
                throw new IllegalArgumentException(String.format("Invalid batch size %d provided. Batch size must be greater than 0", batchSize));
            }
            this.batchSize = batchSize;
            if (reducingFactor <= 1) {
                throw new IllegalArgumentException(String.format("Invalid decaying factor %d provided. Decaying factor must be greater than 1", batchSize));
            }
            if (maxRetries < 0) {
                throw new IllegalArgumentException(String.format("Invalid number of maximum retries %d provided. It must be a non-negative integer value", maxRetries));
            }
            this.maxRetries = maxRetries;
            this.decayingFactor = reducingFactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T run() throws Exception {
            int attempt = 0;
            while (true) {
                Object t;
                block7: {
                    int size;
                    if ((size = this.getNextBatchSize()) == 0) {
                        throw new RetryException("Batch size reduced to zero");
                    }
                    try {
                        t = this.execute(size);
                        if (++attempt != this.maxRetries) break block7;
                    }
                    catch (Exception ex) {
                        try {
                            LOG.warn(String.format("Exception thrown while processing using a batch size %d", size), (Throwable)ex);
                            if (++attempt != this.maxRetries) continue;
                        }
                        catch (Throwable throwable) {
                            if (++attempt == this.maxRetries) {
                                throw new RetryException(String.format("Maximum number of retry attempts %d exhausted", this.maxRetries));
                            }
                            throw throwable;
                        }
                        throw new RetryException(String.format("Maximum number of retry attempts %d exhausted", this.maxRetries));
                    }
                    throw new RetryException(String.format("Maximum number of retry attempts %d exhausted", this.maxRetries));
                }
                return t;
                break;
            }
        }

        private int getNextBatchSize() {
            int ret = this.batchSize;
            this.batchSize /= this.decayingFactor;
            return ret;
        }
    }

    public static interface ExponentialBackOffRetry<T> {
        public T execute(int var1) throws Exception;
    }

    public static class RetryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RetryException(Exception ex) {
            super(ex);
        }

        public RetryException(String msg) {
            super(msg);
        }
    }
}

