/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.io.Text;

public class LazyObjectInspectorParametersImpl
implements LazyObjectInspectorParameters {
    protected boolean escaped;
    protected byte escapeChar;
    protected boolean extendedBooleanLiteral;
    protected List<String> timestampFormats;
    protected byte[] separators;
    protected Text nullSequence;
    protected boolean lastColumnTakesRest;

    public LazyObjectInspectorParametersImpl() {
        this.escaped = false;
        this.extendedBooleanLiteral = false;
        this.timestampFormats = null;
    }

    public LazyObjectInspectorParametersImpl(boolean escaped, byte escapeChar, boolean extendedBooleanLiteral, List<String> timestampFormats, byte[] separators, Text nullSequence) {
        this.escaped = escaped;
        this.escapeChar = escapeChar;
        this.extendedBooleanLiteral = extendedBooleanLiteral;
        this.timestampFormats = timestampFormats;
        this.separators = separators;
        this.nullSequence = nullSequence;
        this.lastColumnTakesRest = false;
    }

    public LazyObjectInspectorParametersImpl(boolean escaped, byte escapeChar, boolean extendedBooleanLiteral, List<String> timestampFormats, byte[] separators, Text nullSequence, boolean lastColumnTakesRest) {
        this.escaped = escaped;
        this.escapeChar = escapeChar;
        this.extendedBooleanLiteral = extendedBooleanLiteral;
        this.timestampFormats = timestampFormats;
        this.separators = separators;
        this.nullSequence = nullSequence;
        this.lastColumnTakesRest = lastColumnTakesRest;
    }

    public LazyObjectInspectorParametersImpl(LazyObjectInspectorParameters lazyParams) {
        this.escaped = lazyParams.isEscaped();
        this.escapeChar = lazyParams.getEscapeChar();
        this.extendedBooleanLiteral = lazyParams.isExtendedBooleanLiteral();
        this.timestampFormats = lazyParams.getTimestampFormats();
        this.separators = lazyParams.getSeparators();
        this.nullSequence = lazyParams.getNullSequence();
        this.lastColumnTakesRest = lazyParams.isLastColumnTakesRest();
    }

    @Override
    public boolean isEscaped() {
        return this.escaped;
    }

    @Override
    public byte getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    public boolean isExtendedBooleanLiteral() {
        return this.extendedBooleanLiteral;
    }

    @Override
    public List<String> getTimestampFormats() {
        return this.timestampFormats;
    }

    @Override
    public byte[] getSeparators() {
        return this.separators;
    }

    @Override
    public Text getNullSequence() {
        return this.nullSequence;
    }

    @Override
    public boolean isLastColumnTakesRest() {
        return this.lastColumnTakesRest;
    }

    protected boolean equals(LazyObjectInspectorParametersImpl other) {
        return this.escaped == other.escaped && this.escapeChar == other.escapeChar && this.extendedBooleanLiteral == other.extendedBooleanLiteral && this.lastColumnTakesRest == other.lastColumnTakesRest && ObjectUtils.equals((Object)this.nullSequence, (Object)other.nullSequence) && Arrays.equals(this.separators, other.separators) && ObjectUtils.equals(this.timestampFormats, other.timestampFormats);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LazyObjectInspectorParametersImpl)) {
            return false;
        }
        return this.equals((LazyObjectInspectorParametersImpl)obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.escaped).append(this.escapeChar).append(this.extendedBooleanLiteral).append(this.timestampFormats).append(this.lastColumnTakesRest).append((Object)this.nullSequence).append(this.separators).toHashCode();
    }
}

