/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyTimestamp
extends LazyPrimitive<LazyTimestampObjectInspector, TimestampWritableV2> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyTimestamp.class);

    public LazyTimestamp(LazyTimestampObjectInspector oi) {
        super(oi);
        this.data = new TimestampWritableV2();
    }

    public LazyTimestamp(LazyTimestamp copy) {
        super(copy);
        this.data = new TimestampWritableV2((TimestampWritableV2)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s = null;
        if (!LazyUtils.isDateMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            s = new String(bytes.getData(), start, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding found ", (Throwable)e);
            s = "";
        }
        Timestamp t = null;
        if (s.compareTo("NULL") == 0) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
        } else {
            try {
                t = ((LazyTimestampObjectInspector)this.oi).getTimestampParser().parseTimestamp(s);
                this.isNull = false;
            }
            catch (IllegalArgumentException e) {
                this.isNull = true;
                this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
            }
        }
        ((TimestampWritableV2)this.data).set(t);
    }

    public static void writeUTF8(OutputStream out, TimestampWritableV2 i) throws IOException {
        if (i == null) {
            out.write(TimestampWritableV2.nullBytes);
        } else {
            out.write(i.toString().getBytes("US-ASCII"));
        }
    }

    @Override
    public TimestampWritableV2 getWritableObject() {
        return (TimestampWritableV2)this.data;
    }
}

