/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Order;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder.SerdeAndColsBuilder;

abstract class StorageDescriptorBuilder<T>
extends SerdeAndColsBuilder<T> {
    private static final String INPUT_FORMAT = "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.HiveInputFormat";
    private static final String OUTPUT_FORMAT = "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.HiveOutputFormat";
    private String location;
    private String inputFormat = "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.HiveInputFormat";
    private String outputFormat = "org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.HiveOutputFormat";
    private int numBuckets = 0;
    private Map<String, String> storageDescriptorParams = new HashMap<String, String>();
    private boolean compressed = false;
    private boolean storedAsSubDirectories;
    private List<String> bucketCols = new ArrayList<String>();
    private List<String> skewedColNames;
    private List<Order> sortCols = new ArrayList<Order>();
    private List<List<String>> skewedColValues;
    private Map<List<String>, String> skewedColValueLocationMaps;

    protected StorageDescriptorBuilder() {
        this.skewedColNames = new ArrayList<String>();
        this.skewedColValues = new ArrayList<List<String>>();
        this.skewedColValueLocationMaps = new HashMap<List<String>, String>();
    }

    protected StorageDescriptor buildSd() throws MetaException {
        StorageDescriptor sd = new StorageDescriptor(this.getCols(), this.location, this.inputFormat, this.outputFormat, this.compressed, this.numBuckets, this.buildSerde(), this.bucketCols, this.sortCols, this.storageDescriptorParams);
        sd.setStoredAsSubDirectories(this.storedAsSubDirectories);
        if (this.skewedColNames != null) {
            SkewedInfo skewed = new SkewedInfo(this.skewedColNames, this.skewedColValues, this.skewedColValueLocationMaps);
            sd.setSkewedInfo(skewed);
        }
        return sd;
    }

    public T setLocation(String location) {
        this.location = location;
        return (T)this.child;
    }

    public T setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
        return (T)this.child;
    }

    public T setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
        return (T)this.child;
    }

    public T setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
        return (T)this.child;
    }

    public T setStorageDescriptorParams(Map<String, String> storageDescriptorParams) {
        this.storageDescriptorParams = storageDescriptorParams;
        return (T)this.child;
    }

    public T addStorageDescriptorParam(String key, String value) {
        if (this.storageDescriptorParams == null) {
            this.storageDescriptorParams = new HashMap<String, String>();
        }
        this.storageDescriptorParams.put(key, value);
        return (T)this.child;
    }

    public T setCompressed(boolean compressed) {
        this.compressed = compressed;
        return (T)this.child;
    }

    public T setStoredAsSubDirectories(boolean storedAsSubDirectories) {
        this.storedAsSubDirectories = storedAsSubDirectories;
        return (T)this.child;
    }

    public T setBucketCols(List<String> bucketCols) {
        this.bucketCols = bucketCols;
        return (T)this.child;
    }

    public T addBucketCol(String bucketCol) {
        if (this.bucketCols == null) {
            this.bucketCols = new ArrayList<String>();
        }
        this.bucketCols.add(bucketCol);
        return (T)this.child;
    }

    public T setSkewedColNames(List<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
        return (T)this.child;
    }

    public T addSkewedColName(String skewedColName) {
        if (this.skewedColNames == null) {
            this.skewedColNames = new ArrayList<String>();
        }
        this.skewedColNames.add(skewedColName);
        return (T)this.child;
    }

    public T setSortCols(List<Order> sortCols) {
        this.sortCols = sortCols;
        return (T)this.child;
    }

    public T addSortCol(String col, int order) {
        if (this.sortCols == null) {
            this.sortCols = new ArrayList<Order>();
        }
        this.sortCols.add(new Order(col, order));
        return (T)this.child;
    }

    public T setSkewedColValues(List<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
        return (T)this.child;
    }

    public T setSkewedColValueLocationMaps(Map<List<String>, String> skewedColValueLocationMaps) {
        this.skewedColValueLocationMaps = skewedColValueLocationMaps;
        return (T)this.child;
    }
}

