/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.client.builder.SerdeAndColsBuilder;

public class SchemaVersionBuilder
extends SerdeAndColsBuilder<SchemaVersionBuilder> {
    private String schemaName;
    private String dbName = "default";
    private String catName = "hive";
    private int version = -1;
    private long createdAt = System.currentTimeMillis() / 1000L;
    private SchemaVersionState state;
    private String description;
    private String schemaText;
    private String fingerprint;
    private String name;

    public SchemaVersionBuilder() {
        super.setChild(this);
    }

    public SchemaVersionBuilder setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public SchemaVersionBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public SchemaVersionBuilder versionOf(ISchema schema) {
        this.catName = schema.getCatName();
        this.dbName = schema.getDbName();
        this.schemaName = schema.getName();
        return this;
    }

    public SchemaVersionBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    public SchemaVersionBuilder setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public SchemaVersionBuilder setState(SchemaVersionState state) {
        this.state = state;
        return this;
    }

    public SchemaVersionBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public SchemaVersionBuilder setSchemaText(String schemaText) {
        this.schemaText = schemaText;
        return this;
    }

    public SchemaVersionBuilder setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public SchemaVersionBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SchemaVersion build() throws MetaException {
        if (this.schemaName == null || this.version < 0) {
            throw new MetaException("You must provide the schema name, and schema version");
        }
        SchemaVersion schemaVersion = new SchemaVersion(new ISchemaName(this.catName, this.dbName, this.schemaName), this.version, this.createdAt, this.getCols());
        if (this.state != null) {
            schemaVersion.setState(this.state);
        }
        if (this.description != null) {
            schemaVersion.setDescription(this.description);
        }
        if (this.schemaText != null) {
            schemaVersion.setSchemaText(this.schemaText);
        }
        if (this.fingerprint != null) {
            schemaVersion.setFingerprint(this.fingerprint);
        }
        if (this.name != null) {
            schemaVersion.setName(this.name);
        }
        schemaVersion.setSerDe(this.buildSerde());
        return schemaVersion;
    }
}

